/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.quantiles;

import java.util.ArrayList;
import java.util.List;
import org.javasimon.Simon;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.callback.quantiles.Buckets;
import org.javasimon.callback.quantiles.BucketsType;
import org.javasimon.callback.quantiles.QuantilesCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoQuantilesCallback
extends QuantilesCallback {
    public static final String ATTR_NAME_BUCKETS_VALUES = "bucketsValues";
    private final long warmupCounter;
    private final int bucketNb;

    public AutoQuantilesCallback() {
        this.warmupCounter = 10L;
        this.bucketNb = 8;
    }

    public AutoQuantilesCallback(long warmupCounter, int bucketNb) {
        this.warmupCounter = warmupCounter;
        this.bucketNb = bucketNb;
    }

    public AutoQuantilesCallback(BucketsType bucketsType, long warmupCounter, int bucketNb) {
        super(bucketsType);
        this.warmupCounter = warmupCounter;
        this.bucketNb = bucketNb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getOrCreateBucketsValues(Stopwatch stopwatch) {
        Stopwatch stopwatch2 = stopwatch;
        synchronized (stopwatch2) {
            List<Long> values = this.getBucketsValues(stopwatch);
            if (values == null) {
                values = new ArrayList<Long>((int)this.warmupCounter);
                stopwatch.setAttribute(ATTR_NAME_BUCKETS_VALUES, values);
            }
            return values;
        }
    }

    private List<Long> getBucketsValues(Stopwatch stopwatch) {
        return (List)stopwatch.getAttribute(ATTR_NAME_BUCKETS_VALUES);
    }

    private void removeBucketsValues(Stopwatch stopwatch) {
        stopwatch.removeAttribute(ATTR_NAME_BUCKETS_VALUES);
    }

    protected Buckets createBucketsAfterWarmup(Stopwatch stopwatch) {
        long min = stopwatch.getMin() * 90L / 100L;
        min = Math.max(0L, min);
        min = min / 1000000L * 1000000L;
        long max = stopwatch.getMax() * 110L / 100L;
        max = (max / 1000000L + 1L) * 1000000L;
        return this.createBuckets(stopwatch, min, max, this.bucketNb);
    }

    @Override
    protected final Buckets createBuckets(Stopwatch stopwatch) {
        if (stopwatch.getCounter() > this.warmupCounter) {
            Buckets buckets = this.createBucketsAfterWarmup(stopwatch);
            buckets.addValues(this.getBucketsValues(stopwatch));
            this.removeBucketsValues(stopwatch);
            return buckets;
        }
        return null;
    }

    @Override
    public void onSimonCreated(Simon simon) {
        if (simon instanceof Stopwatch) {
            Stopwatch stopwatch = (Stopwatch)simon;
            this.getOrCreateBucketsValues(stopwatch);
        }
    }

    @Override
    protected void onStopwatchSplit(Stopwatch stopwatch, Split split) {
        Buckets buckets = this.getOrCreateBuckets(stopwatch);
        long value = split.runningFor();
        if (buckets == null) {
            this.getOrCreateBucketsValues(stopwatch).add(value);
        } else {
            buckets.addValue(value);
            buckets.log(split);
        }
    }

    @Override
    @Deprecated
    public void onSimonReset(Simon simon) {
        if (simon instanceof Stopwatch) {
            Stopwatch stopwatch = (Stopwatch)simon;
            Buckets buckets = AutoQuantilesCallback.getBuckets(stopwatch);
            if (buckets == null) {
                List<Long> values = this.getBucketsValues(stopwatch);
                if (values != null) {
                    values.clear();
                }
            } else {
                buckets.clear();
            }
        }
    }
}

