/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.status;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemStatus;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.DefaultEstimateExtractor;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.issues.IssueSyncData;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.rest.entities.assignment.RestReleaseStreamAssignment;
import com.radiantminds.roadmap.common.rest.entities.assignment.RestTeamResourceAssignment;
import com.radiantminds.roadmap.common.rest.entities.workitems.status.RestWorkItemStatus;
import com.radiantminds.roadmap.common.rest.services.common.Operation;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraintChecker;
import java.util.Map;

public class StatusOperation
extends Operation {
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioEstimatePersistence estimatePersistence;
    private final PortfolioStreamPersistence streamPersistence;
    private final PortfolioTeamPersistence teamPersistence;
    private final DataMode dataMode;
    private final Map<String, RestWorkItemStatus> statuses;
    private final WorkItemConstraintChecker workItemConstraintChecker;
    private final DefaultEstimateExtractor defaultEstimateExtractor;
    private PortfolioToJiraSyncExtension portfolioToJiraSyncExtension;

    public StatusOperation(PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, PortfolioStreamPersistence streamPersistence, PortfolioTeamPersistence teamPersistence, PortfolioPlanPersistence planPersistence, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension, DataMode dataMode, Map<String, RestWorkItemStatus> statuses) {
        this.workItemPersistence = workItemPersistence;
        this.estimatePersistence = estimatePersistence;
        this.streamPersistence = streamPersistence;
        this.teamPersistence = teamPersistence;
        this.portfolioToJiraSyncExtension = portfolioToJiraSyncExtension;
        this.dataMode = dataMode;
        this.statuses = statuses;
        this.workItemConstraintChecker = new WorkItemConstraintChecker(workItemPersistence);
        this.defaultEstimateExtractor = new DefaultEstimateExtractor(workItemPersistence, planPersistence);
    }

    @Override
    public void preItemCheck(String workItemId) throws Exception {
        RestReleaseStreamAssignment streamReleaseAssignment;
        String constraintCheck = this.workItemConstraintChecker.isAssignable(workItemId);
        if (constraintCheck != null) {
            throw new Exception("type-not-assignable");
        }
        RestWorkItemStatus status = this.statuses.get(workItemId);
        RestTeamResourceAssignment teamResourceAssignment = status.getTeamResourceAssignment();
        if (teamResourceAssignment != null) {
            boolean valid;
            if (teamResourceAssignment.getTeamId() != null && !this.teamPersistence.exists(teamResourceAssignment.getTeamId())) {
                throw new Exception("invalid-team-assignment");
            }
            if (teamResourceAssignment.getResourceIds() != null && teamResourceAssignment.getResourceIds().size() > 0 && !(valid = this.workItemPersistence.validateTeamSprintResourceAssignment(teamResourceAssignment.getTeamId(), teamResourceAssignment.getSprintId(), teamResourceAssignment.getResourceIds()))) {
                throw new Exception("invalid-team-assignment");
            }
        }
        if ((streamReleaseAssignment = status.getStreamReleaseAssignment()) != null) {
            boolean valid;
            if (streamReleaseAssignment.getStreamId() == null) {
                throw new Exception("invalid-stream-assignment");
            }
            if (!this.streamPersistence.exists(streamReleaseAssignment.getStreamId())) {
                throw new Exception("invalid-stream-assignment");
            }
            if (streamReleaseAssignment.getReleaseId() != null && !(valid = this.workItemPersistence.validateStreamReleaseAssignment(streamReleaseAssignment.getStreamId(), streamReleaseAssignment.getReleaseId()))) {
                throw new Exception("invalid-stream-assignment");
            }
        }
    }

    @Override
    public void performOperation(String workItemId) throws Exception {
        boolean replanning = this.dataMode == DataMode.Replanning;
        RestWorkItemStatus status = this.statuses.get(workItemId);
        RestTeamResourceAssignment teamResourceAssignment = status.getTeamResourceAssignment();
        RestReleaseStreamAssignment streamReleaseAssignment = status.getStreamReleaseAssignment();
        if (replanning) {
            this.workItemPersistence.setReplanningStatus(workItemId, status.getStatus());
        } else {
            this.workItemPersistence.setStatus(workItemId, status.getStatus());
        }
        if (streamReleaseAssignment != null) {
            this.workItemPersistence.setStreamReleaseAssignment(workItemId, streamReleaseAssignment.getStreamId(), streamReleaseAssignment.getReleaseId(), replanning);
        }
        if (teamResourceAssignment != null) {
            this.workItemPersistence.setTeamSprintResourceAssignment(workItemId, teamResourceAssignment.getTeamId(), teamResourceAssignment.getSprintId(), teamResourceAssignment.getResourceIds(), replanning);
        }
        if (WorkItemStatus.COMPLETED.is(status.getStatus()) && !replanning) {
            Optional<Double> defaultEstimate = this.defaultEstimateExtractor.defaultEstimateForWorkItem(workItemId);
            this.estimatePersistence.copyCurrentToOriginalEstimates(workItemId, defaultEstimate, false);
            this.portfolioToJiraSyncExtension.syncWorkItemToIssues(IssueSyncData.createEstimateSyncFor(workItemId));
            this.workItemPersistence.deleteReplanningTeam(workItemId);
            this.workItemPersistence.deleteReplanningRelease(workItemId);
            this.workItemPersistence.deleteReplanningStream(workItemId);
            this.workItemPersistence.deleteResourceAssignments(Lists.newArrayList((Object[])new String[]{workItemId}), true);
            this.workItemPersistence.deleteReplanningStatus(workItemId);
            this.workItemPersistence.clearEstimatesForWorkItem(workItemId, true, false);
        }
    }
}

