/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.common;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.people.IterationStartType;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingInterval;
import com.radiantminds.roadmap.common.data.entities.plans.PlanningUnit;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingConfig;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.data.entities.releases.SchedulingRelease;
import com.radiantminds.roadmap.common.data.entities.releases.SchedulingStream;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemStatus;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.common.TimeAmountTransformer;
import com.radiantminds.roadmap.common.scheduling.common.TimeAmountTransformerFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

@Immutable
public class TimeTransformer
implements ITimeTransformer {
    private static final Log LOGGER = Log.with(ITimeTransformer.class);
    private final DateTime zeroDateTime;
    private final TimeAmountTransformer timeAmountTransformer;

    TimeTransformer(long zeroDayInstant, TimeAmountTransformer timeAmountTransformer) {
        long zeroInstant = new DateTime(zeroDayInstant, DateTimeZone.UTC).withMillisOfDay(0).getMillis();
        this.zeroDateTime = new DateTime(zeroInstant, DateTimeZone.UTC);
        this.timeAmountTransformer = timeAmountTransformer;
    }

    @Override
    public float getWorkInPlanningUnit(double hours) {
        return this.timeAmountTransformer.getWorkInPlanningUnit(hours);
    }

    @Override
    public boolean isBeforeZeroInstant(long instant) {
        return instant < this.zeroDateTime.getMillis();
    }

    @Override
    public int getNextTimeStep(IterationStartType iterationStartType) {
        switch (iterationStartType) {
            case WithReleaseStartDate: {
                return 0;
            }
            case OnMondays: {
                return this.getShift(1);
            }
            case OnTuesdays: {
                return this.getShift(2);
            }
            case OnWednesdays: {
                return this.getShift(3);
            }
            case OnThursdays: {
                return this.getShift(4);
            }
            case OnFridays: {
                return this.getShift(5);
            }
            case OnSaturdays: {
                return this.getShift(6);
            }
            case OnSundays: {
                return this.getShift(7);
            }
        }
        throw new IllegalArgumentException("unknown type");
    }

    private int getShift(int day) {
        int sameWeekStep = Days.daysBetween((ReadableInstant)this.zeroDateTime, (ReadableInstant)this.zeroDateTime.withDayOfWeek(day)).getDays();
        if (sameWeekStep >= 0) {
            return sameWeekStep;
        }
        return Days.daysBetween((ReadableInstant)this.zeroDateTime, (ReadableInstant)this.zeroDateTime.plusWeeks(1).withDayOfWeek(day)).getDays();
    }

    @Override
    public Optional<IIntegerInterval> tryTransformUpperLimitOptionalInterval(SchedulingInterval interval) {
        if (interval.getStartDate() == null) {
            return Optional.absent();
        }
        if (interval.getEndDate() == null) {
            return this.tryTransformInstant(interval.getStartDate());
        }
        return this.tryTransformInstant(interval.getStartDate(), interval.getEndDate());
    }

    @Override
    public Interval transformInterval(IIntegerInterval timeStepInterval) {
        DateTime dayStartInstant = new DateTime(this.getInstant(timeStepInterval.getStart()), DateTimeZone.UTC).withMillisOfDay(0);
        DateTime dayEndInstant = new DateTime(this.getInstant(timeStepInterval.getEnd()), DateTimeZone.UTC).plusDays(1).withMillisOfDay(0).minusMillis(1);
        return new Interval((ReadableInstant)dayStartInstant, (ReadableInstant)dayEndInstant);
    }

    private Optional<IIntegerInterval> tryTransformInstant(long startDate, long endDate) {
        if (this.isBeforeZeroInstant(endDate)) {
            return Optional.absent();
        }
        return Optional.of((Object)new IntegerInterval(this.getZeroInstantSafeTimestep(startDate), this.getTimestep(endDate)));
    }

    private Optional<IIntegerInterval> tryTransformInstant(long instant) {
        if (this.isBeforeZeroInstant(instant)) {
            return Optional.absent();
        }
        return Optional.of((Object)new IntegerInterval(this.getTimestep(instant)));
    }

    @Override
    public long getInstant(int timestep) {
        Preconditions.checkArgument((timestep >= 0 ? 1 : 0) != 0, (Object)"timestep must not be negative");
        DateTime date = this.zeroDateTime.plusDays(timestep);
        return date.getMillis();
    }

    @Override
    public int getTimestep(long instant) {
        Preconditions.checkArgument((instant >= this.zeroDateTime.getMillis() ? 1 : 0) != 0, (Object)"given instant is smaller zero instant");
        try {
            DateTime endDate = new DateTime(instant, DateTimeZone.UTC);
            Days daysBetween = Days.daysBetween((ReadableInstant)this.zeroDateTime, (ReadableInstant)endDate);
            return daysBetween.getDays();
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
        catch (IllegalFieldValueException e) {
            return Integer.MAX_VALUE;
        }
    }

    @Override
    public int getZeroInstantSafeTimestep(long instant) {
        if (instant < this.zeroDateTime.getMillis()) {
            return 0;
        }
        return this.getTimestep(instant);
    }

    @Override
    public int getDurationInDays(long longValue) {
        Duration duration = new Duration(longValue);
        return (int)duration.getStandardDays();
    }

    @Override
    public PlanningUnit getPlanningUnit() {
        return this.timeAmountTransformer.getPlanningUnit();
    }

    @Override
    public float getNormalizedWorkDemand(float value) {
        return this.timeAmountTransformer.getNormalizedWorkDemand(value);
    }

    public static TimeTransformer createFromPlan(SchedulingPlan plan) {
        LOGGER.debug("create instance from plan: %s", plan);
        TimeTransformer instance = TimeTransformer.createFromPlan(plan, System.currentTimeMillis());
        LOGGER.debug("created instance: %s", instance);
        return instance;
    }

    static TimeTransformer createFromPlan(SchedulingPlan plan, long nowMs) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan must not be null");
        if (plan.getDate().isPresent()) {
            return TimeTransformer.createReplanningTimeTransformer(plan, nowMs);
        }
        long earliestStartInstant = TimeTransformer.getEarliestStreamStart(plan, nowMs);
        TimeAmountTransformer amountTransformer = TimeAmountTransformerFactory.create(plan.getPlanConfiguration());
        return new TimeTransformer(earliestStartInstant, amountTransformer);
    }

    private static long getEarliestStreamStart(SchedulingPlan plan, long nowMs) {
        long minStreamStart = Long.MAX_VALUE;
        Set<String> streamIdsWithOpenItem = TimeTransformer.getStreamsWithOpenItem(plan);
        for (SchedulingStream schedulingStream : plan.getStreams()) {
            if (!streamIdsWithOpenItem.contains(schedulingStream.getId())) {
                LOGGER.debug("stream %s ignored because no assigned undone items", schedulingStream.getId());
                continue;
            }
            SchedulingRelease firstRelease = TimeTransformer.getFirstRelease(schedulingStream);
            minStreamStart = Math.min(minStreamStart, (Long)firstRelease.getFixedStartDate().or((Object)nowMs) + (Long)firstRelease.getDeltaStartDate().or((Object)0L));
        }
        if (minStreamStart == Long.MAX_VALUE) {
            return nowMs;
        }
        return minStreamStart;
    }

    private static SchedulingRelease getFirstRelease(SchedulingStream stream) {
        if (!stream.getReleases().isEmpty()) {
            return stream.getReleases().get(0);
        }
        return stream.getLaterRelease();
    }

    private static Set<String> getStreamsWithOpenItem(SchedulingPlan plan) {
        HashSet streamIds = Sets.newHashSet();
        List<? extends SchedulingWorkItem> items = plan.getWorkItems();
        for (SchedulingWorkItem schedulingWorkItem : items) {
            Integer status = schedulingWorkItem.getStatus();
            if (!WorkItemStatus.OPEN.is(status)) continue;
            streamIds.add(schedulingWorkItem.getStreamId());
        }
        return streamIds;
    }

    private static TimeTransformer createReplanningTimeTransformer(SchedulingPlan plan, long nowMs) {
        long replanningDate = (Long)plan.getDate().get();
        long earliestStreamStart = TimeTransformer.getEarliestStreamStartWithReplanning(plan, replanningDate, nowMs);
        SchedulingConfig planConfiguration = plan.getPlanConfiguration();
        TimeAmountTransformer amountTransformer = TimeAmountTransformerFactory.create(planConfiguration);
        return new TimeTransformer(earliestStreamStart, amountTransformer);
    }

    private static long getEarliestStreamStartWithReplanning(SchedulingPlan plan, long replanningDate, long nowMs) {
        long minStreamStart = Long.MAX_VALUE;
        Set<String> streamIdsWithOpenItem = TimeTransformer.getStreamsWithOpenItem(plan);
        for (SchedulingStream schedulingStream : plan.getStreams()) {
            if (!streamIdsWithOpenItem.contains(schedulingStream.getId())) {
                LOGGER.debug("stream %s ignored because no assigned undone items", schedulingStream.getId());
                continue;
            }
            if (schedulingStream.getReleases().isEmpty()) {
                minStreamStart = Math.min(minStreamStart, Math.max(nowMs, replanningDate));
                continue;
            }
            SchedulingRelease firstRelease = schedulingStream.getReleases().get(0);
            Optional<Long> fixedStart = firstRelease.getFixedStartDate();
            if (fixedStart.isPresent()) {
                long calculatedStartInstant = (Long)fixedStart.get() + (Long)firstRelease.getDeltaStartDate().or((Object)0L);
                minStreamStart = Math.min(minStreamStart, Math.max(calculatedStartInstant, replanningDate));
                continue;
            }
            Optional<Long> delta = schedulingStream.getReleases().get(0).getDeltaStartDate();
            minStreamStart = Math.min(minStreamStart, Math.max(nowMs + (Long)delta.or((Object)0L), replanningDate));
        }
        if (minStreamStart == Long.MAX_VALUE) {
            return replanningDate;
        }
        return minStreamStart;
    }
}

