/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.settings;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.common.HasPercentage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

abstract class PercentableDistributionExtractor {
    PercentableDistributionExtractor() {
    }

    static <T extends HasPercentage> Map<T, Float> createPercentageMap(Collection<T> percentables) {
        HashMap skillPercMap = Maps.newHashMap();
        HashSet skillsWithNoPercentage = Sets.newHashSet();
        float setPercentageSum = 0.0f;
        for (HasPercentage skill : percentables) {
            Double percentage = skill.getPercentage();
            if (percentage == null || percentables.size() == 1) {
                skillsWithNoPercentage.add(skill);
                continue;
            }
            skillPercMap.put(skill, Float.valueOf(percentage.floatValue()));
            setPercentageSum = (float)((double)setPercentageSum + percentage);
        }
        float unassignedPercentages = Math.max(0.0f, 1.0f - setPercentageSum);
        float defaultAssignment = unassignedPercentages / (float)skillsWithNoPercentage.size();
        for (HasPercentage skill : skillsWithNoPercentage) {
            skillPercMap.put(skill, Float.valueOf(defaultAssignment));
        }
        return skillPercMap;
    }
}

