/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.IResourceTypeMapping;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.BaseTeamsTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.point.EmptyPointsTeamTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.point.PointsTeamCreator;

public class PointBasedTeamsTransformer
extends BaseTeamsTransformer {
    private static final Log LOGGER = Log.with(PointBasedTeamsTransformer.class);
    private final PointsTeamCreator pointsTeamCreator;
    private final EmptyPointsTeamTransformer emptyTeamResourceCreator;

    public PointBasedTeamsTransformer(ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        this.pointsTeamCreator = new PointsTeamCreator(timeTransformer, timeStepPresenceFunction);
        this.emptyTeamResourceCreator = new EmptyPointsTeamTransformer(timeTransformer, timeStepPresenceFunction);
    }

    @Override
    protected Optional<IResourceGroup> tryGetResourceGroup(IResourceTypeMapping resourceTypeMapping, SchedulingTeam team, SchedulingPlan plan) {
        LOGGER.debug("try to convert team: %s", team);
        if (team.getPlanningMode().equals((Object)PlanningMode.Kanban)) {
            LOGGER.info("Kanban teams are ignored in story point mode", new Object[0]);
            return Optional.absent();
        }
        if (team.getResources() == null || team.getResources().isEmpty()) {
            LOGGER.debug("create empty story points team", new Object[0]);
            return Optional.of((Object)this.emptyTeamResourceCreator.createEmptyTeam(team, resourceTypeMapping, plan.getPlanConfiguration()));
        }
        LOGGER.debug("create regular story points team", new Object[0]);
        return this.pointsTeamCreator.createWorkResources(team, resourceTypeMapping, plan);
    }
}

