/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.quantiles;

import org.javasimon.callback.quantiles.Bucket;
import org.javasimon.callback.quantiles.Buckets;

public class LinearBuckets
extends Buckets {
    public LinearBuckets(long min, long max, int bucketNb) {
        super(min, max, bucketNb);
        long width = (max - min) / (long)bucketNb;
        long currentMax = min;
        for (int i = 1; i <= bucketNb; ++i) {
            long currentMin = currentMax;
            currentMax = currentMin + width;
            this.buckets[i] = new Bucket(currentMin, currentMax);
        }
    }

    protected Bucket getBucketForValue(long value) {
        Bucket bucket;
        if (value < this.min) {
            bucket = this.buckets[0];
        } else if (value >= this.max) {
            bucket = this.buckets[this.bucketNb + 1];
        } else {
            int bucketIndex = 1 + (int)((value - this.min) * (long)(this.bucketNb - 1) / (this.max - this.min));
            bucket = this.buckets[bucketIndex];
            if (value > bucket.getMax()) {
                bucket = this.buckets[++bucketIndex];
            }
        }
        return bucket;
    }
}

