/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain.util;

import java.net.URI;
import java.util.List;

public class UriUtil {
    private static final List<String> CLOUD_DOMAINS = List.of("atlassian.net", "jira.com");
    private static final List<String> DC_DOMAINS = List.of("localhost");

    public static URI path(URI uri, String path) {
        String uriString = uri.toString();
        StringBuilder sb = new StringBuilder(uriString);
        if (!uriString.endsWith("/")) {
            sb.append('/');
        }
        sb.append(path.startsWith("/") ? path.substring(1) : path);
        return URI.create(sb.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isURICloud(URI uri) {
        String host = uri.getHost().toLowerCase();
        if (!CLOUD_DOMAINS.stream().anyMatch(host::contains)) return false;
        if (!DC_DOMAINS.stream().noneMatch(host::contains)) return false;
        return true;
    }
}

