/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.function.Supplier;

public class MockApplication
implements Application {
    private final ApplicationKey key;
    private ZonedDateTime buildDate = ZonedDateTime.now();

    public MockApplication(ApplicationKey key) {
        this.key = key;
    }

    public MockApplication(String key) {
        this(ApplicationKey.valueOf((String)key));
    }

    public ApplicationKey getKey() {
        return this.key;
    }

    public String getName() {
        return String.format("%s-name", this.key.value());
    }

    public String getDescription() {
        return String.format("%s-description", this.key.value());
    }

    public String getVersion() {
        return String.format("%s-version", this.key);
    }

    public String getUserCountDescription(Option<Integer> count) {
        Supplier<String> unlimited = () -> String.format("Unlimited %s users", this.key);
        return (String)count.map(c -> String.format("%d %s users", c, this.key)).getOrElse(unlimited);
    }

    public Option<URI> getConfigurationURI() {
        return Option.none();
    }

    public Option<URI> getPostInstallURI() {
        return Option.none();
    }

    public Option<URI> getPostUpdateURI() {
        return Option.none();
    }

    public Option<URI> getProductHelpServerSpaceURI() {
        return Option.none();
    }

    public Option<URI> getProductHelpCloudSpaceURI() {
        return Option.none();
    }

    public ZonedDateTime buildZonedDate() {
        return this.buildDate;
    }

    public Option<SingleProductLicenseDetailsView> getLicense() {
        return Option.none();
    }

    public ApplicationAccess getAccess() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getDefaultGroup() {
        return this.key.value() + "-group";
    }

    public void clearConfiguration() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public MockApplication buildDate(Date date) {
        this.buildDate = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return this;
    }
}

