/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.user.MockGroup;
import com.atlassian.jira.util.Streams;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class MockApplicationRole
implements ApplicationRole {
    private ApplicationKey key;
    private Set<Group> groups;
    private Set<Group> defaultGroups;
    private String name;
    private int numberOfLicenseSeats;
    private boolean selectedByDefault;
    private boolean defined;
    private boolean platform;

    public MockApplicationRole() {
        this.groups = Sets.newHashSet();
        this.defaultGroups = Sets.newHashSet();
    }

    public MockApplicationRole(ApplicationKey key) {
        this();
        this.key = key;
        this.name = key.toString();
    }

    public MockApplicationRole(ApplicationRole copy) {
        this.key = copy.getKey();
        this.groups = Sets.newHashSet((Iterable)copy.getGroups());
        this.defaultGroups = Sets.newHashSet((Iterable)copy.getDefaultGroups());
        this.name = copy.getName();
        this.numberOfLicenseSeats = copy.getNumberOfSeats();
        this.selectedByDefault = copy.isSelectedByDefault();
        this.defined = copy.isDefined();
        this.platform = copy.isPlatform();
    }

    public MockApplicationRole key(String id) {
        this.key = ApplicationKey.valueOf((String)id);
        return this;
    }

    public MockApplicationRole key(ApplicationKey key) {
        this.key = key;
        return this;
    }

    public MockApplicationRole name(String name) {
        this.name = name;
        return this;
    }

    public MockApplicationRole groups(Group ... groups) {
        this.groups = Sets.newHashSet((Object[])groups);
        return this;
    }

    public MockApplicationRole groupNames(String ... groups) {
        return this.groups(MockApplicationRole.toGroups(groups));
    }

    public MockApplicationRole groups(Iterable<Group> groups) {
        this.groups = Sets.newHashSet(groups);
        return this;
    }

    public MockApplicationRole groupNames(Iterable<String> groups) {
        return this.groups(MockApplicationRole.toGroups(groups));
    }

    public MockApplicationRole defaultGroups(Group ... group) {
        this.defaultGroups = Sets.newHashSet((Object[])group);
        return this;
    }

    public MockApplicationRole defaultGroupNames(String ... names) {
        return this.defaultGroups(MockApplicationRole.toGroups(names));
    }

    public MockApplicationRole defaultGroups(Iterable<Group> groups) {
        this.defaultGroups = Sets.newHashSet(groups);
        return this;
    }

    public MockApplicationRole defaultGroupNames(Iterable<String> names) {
        return this.defaultGroups(MockApplicationRole.toGroups(names));
    }

    public MockApplicationRole numberOfSeats(int numberOfLicenseSeats) {
        this.numberOfLicenseSeats = numberOfLicenseSeats;
        return this;
    }

    public MockApplicationRole selectedByDefault(boolean selectedByDefault) {
        this.selectedByDefault = selectedByDefault;
        return this;
    }

    public MockApplicationRole defined(boolean defined) {
        this.defined = defined;
        return this;
    }

    public MockApplicationRole unlimitedSeats() {
        return this.numberOfSeats(-1);
    }

    @Nonnull
    public ApplicationKey getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Set<Group> getGroups() {
        return this.groups;
    }

    @Nonnull
    public Set<Group> getDefaultGroups() {
        return this.defaultGroups;
    }

    @Nonnull
    public ApplicationRole withGroups(@Nonnull Iterable<Group> groups, @Nonnull Iterable<Group> defaultGroups) {
        return new MockApplicationRole(this).groups(groups).defaultGroups(defaultGroups);
    }

    public int getNumberOfSeats() {
        return this.numberOfLicenseSeats;
    }

    public boolean isSelectedByDefault() {
        return this.selectedByDefault;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public boolean isPlatform() {
        return this.platform;
    }

    public ApplicationRole withSelectedByDefault(boolean selectedByDefault) {
        return new MockApplicationRole(this).selectedByDefault(selectedByDefault);
    }

    public MockApplicationRole copy() {
        return new MockApplicationRole(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockApplicationRole that = (MockApplicationRole)o;
        return this.key != null ? this.key.equals((Object)that.key) : that.key == null;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("key", (Object)this.getKey()).append("groups", this.groups).append("defaultGroups", this.defaultGroups).append("numberOfSeats", this.numberOfLicenseSeats).append("selectedByDefault", this.selectedByDefault).append("defined", this.defined).append("platform", this.platform).toString();
    }

    private static Iterable<Group> toGroups(Iterable<String> names) {
        return Streams.stream(names).map(MockGroup::new).collect(Collectors.toList());
    }

    private static Iterable<Group> toGroups(String ... names) {
        return Arrays.stream(names).map(MockGroup::new).collect(Collectors.toList());
    }

    private static Group toGroup(String name) {
        return new MockGroup(name);
    }
}

