/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeImpl;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.priority.PriorityImpl;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.resolution.ResolutionImpl;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.StatusImpl;
import com.atlassian.jira.model.querydsl.IssueTypeDTO;
import com.atlassian.jira.model.querydsl.PriorityDTO;
import com.atlassian.jira.model.querydsl.ResolutionDTO;
import com.atlassian.jira.model.querydsl.StatusDTO;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import org.ofbiz.core.entity.GenericValue;

public class MockIssueConstantFactory
implements IssueConstantFactory {
    private final StatusCategoryManager statusCategoryManager;
    private final OfBizDelegator ofBizDelegator;

    public MockIssueConstantFactory(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
        this.statusCategoryManager = null;
    }

    public MockIssueConstantFactory(StatusCategoryManager statusCategoryManager, OfBizDelegator ofBizDelegator) {
        this.statusCategoryManager = statusCategoryManager;
        this.ofBizDelegator = ofBizDelegator;
    }

    public Priority createPriority(GenericValue priorityGv) {
        return new PriorityImpl(priorityGv, null, null, null);
    }

    public IssueType createIssueType(GenericValue issueTypeGv) {
        return new IssueTypeImpl(issueTypeGv, null, null, null, null);
    }

    public Resolution createResolution(GenericValue resolutionGv) {
        return new ResolutionImpl(resolutionGv, null, null, null);
    }

    public Status createStatus(GenericValue statusGv) {
        return new StatusImpl(statusGv, null, null, null, this.statusCategoryManager);
    }

    public Priority createPriority(PriorityDTO priorityDTO) {
        GenericValue gv = priorityDTO.toGenericValue(this.ofBizDelegator);
        return this.createPriority(gv);
    }

    public IssueType createIssueType(IssueTypeDTO issueTypeDTO) {
        GenericValue gv = issueTypeDTO.toGenericValue(this.ofBizDelegator);
        return this.createIssueType(gv);
    }

    public Resolution createResolution(ResolutionDTO resolutionDTO) {
        GenericValue gv = resolutionDTO.toGenericValue(this.ofBizDelegator);
        return this.createResolution(gv);
    }

    public Status createStatus(StatusDTO statusDTO) {
        GenericValue gv = statusDTO.toGenericValue(this.ofBizDelegator);
        return this.createStatus(gv);
    }
}

