/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.Mockito;

public abstract class TestData {
    public static final long DIRECTORY_ID = 123L;

    public static class Application {
        public static final String NAME = "Test Application";
        public static final boolean ACTIVE = true;
        public static final String DESCRIPTION = "test description";
        public static final ApplicationType TYPE = ApplicationType.JIRA;
        public static final HashSet<RemoteAddress> ADDRESSES = Sets.newHashSet((Object[])new RemoteAddress[]{new RemoteAddress("10.10.10.10"), new RemoteAddress("10.10.10.11")});
        public static final PasswordCredential CREDENTIAL = new PasswordCredential("secret", true);

        public static ApplicationImpl getUnmockedTestData() {
            return Application.getUnmockedTestData(NAME);
        }

        public static void assertEqualsTestApplication(com.atlassian.crowd.model.application.Application application) {
            Assert.assertEquals((Object)NAME, (Object)application.getName());
            Assert.assertEquals((Object)true, (Object)application.isActive());
            Assert.assertEquals((Object)DESCRIPTION, (Object)application.getDescription());
            Assert.assertEquals((long)ADDRESSES.size(), (long)application.getRemoteAddresses().size());
            Assert.assertTrue((boolean)ADDRESSES.containsAll(application.getRemoteAddresses()));
        }

        public static ApplicationImpl getUnmockedTestData(String applicationName) {
            ApplicationImpl application = ApplicationImpl.newInstance((String)applicationName, (ApplicationType)ApplicationType.JIRA);
            application.setActive(true);
            application.setDescription(DESCRIPTION);
            application.setCredential(CREDENTIAL);
            application.setRemoteAddresses(ADDRESSES);
            application.setAttribute("attribute1", "value11");
            return application;
        }
    }

    public static class Directory {
        public static final String NAME = "Test Directory";
        public static final boolean ACTIVE = true;
        public static final DirectoryType TYPE = DirectoryType.INTERNAL;
        private static final String IMPL_NAME = InternalDirectory.class.getCanonicalName();
        private static final Set<OperationType> OPERATIONS = ImmutableSet.of((Object)OperationType.CREATE_GROUP, (Object)OperationType.CREATE_USER);
        private static final String DESCRIPTION = "test description";
        private static final Map<String, String> ATTRIBUTES = ImmutableMap.of((Object)"attribute1", (Object)"value11", (Object)"attribute2", (Object)"value21");

        public static DirectoryImpl getTestData() {
            return Directory.getDirectory(NAME, true, TYPE, IMPL_NAME, DESCRIPTION, OPERATIONS, ATTRIBUTES);
        }

        public static DirectoryImpl getUnmockedTestData() {
            return Directory.getUnmockedTestData(NAME);
        }

        public static DirectoryImpl getDirectory(String name, boolean active, DirectoryType type, String implClass, String description, Set<OperationType> operations, Map<String, String> attributes) {
            DirectoryImpl directory = (DirectoryImpl)Mockito.mock(DirectoryImpl.class);
            Mockito.when((Object)directory.getName()).thenReturn((Object)name);
            Mockito.when((Object)directory.isActive()).thenReturn((Object)active);
            Mockito.when((Object)directory.getType()).thenReturn((Object)type);
            Mockito.when((Object)directory.getImplementationClass()).thenReturn((Object)implClass);
            Mockito.when((Object)directory.getDescription()).thenReturn((Object)description);
            Mockito.when((Object)directory.getAttributes()).thenReturn(attributes);
            Mockito.when((Object)directory.getAllowedOperations()).thenReturn(operations);
            return directory;
        }

        public static void assertEqualsTestDirectory(com.atlassian.crowd.embedded.api.Directory directory) {
            Assert.assertEquals((Object)NAME, (Object)directory.getName());
            Assert.assertEquals((Object)true, (Object)directory.isActive());
            Assert.assertEquals((Object)TYPE, (Object)directory.getType());
            Assert.assertEquals((Object)IMPL_NAME, (Object)directory.getImplementationClass());
            Assert.assertEquals((Object)DESCRIPTION, (Object)directory.getDescription());
            Assert.assertThat((Object)directory.getValues("attribute1"), (Matcher)Matchers.contains((Object[])new String[]{"value11"}));
            Assert.assertThat((Object)directory.getValues("attribute2"), (Matcher)Matchers.contains((Object[])new String[]{"value21"}));
            Assert.assertThat((Object)directory.getKeys(), (Matcher)Matchers.is(ATTRIBUTES.keySet()));
            Assert.assertThat((Object)directory.getAllowedOperations(), (Matcher)Matchers.is(OPERATIONS));
        }

        public static DirectoryImpl getUnmockedTestData(String directoryName) {
            DirectoryImpl directory = new DirectoryImpl();
            directory.setName(directoryName);
            directory.setActive(true);
            directory.setType(TYPE);
            directory.setImplementationClass(IMPL_NAME);
            directory.setDescription(DESCRIPTION);
            directory.setAttributes(ATTRIBUTES);
            directory.setAllowedOperations(OPERATIONS);
            return directory;
        }
    }

    public static class Attributes {
        public static final String ATTRIBUTE1 = "attribute1";
        public static final String ATTRIBUTE2 = "attribute2";
        public static final String ATTRIBUTE3 = "attribute3";
        public static final String VALUE_11 = "value11";
        public static final String VALUE_21 = "value21";
        public static final String VALUE_22 = "value22";

        public static Map<String, Set<String>> getTestData() {
            HashMap attributes = Maps.newHashMap();
            attributes.put(ATTRIBUTE1, Sets.newHashSet((Object[])new String[]{VALUE_11}));
            attributes.put(ATTRIBUTE2, Sets.newHashSet((Object[])new String[]{VALUE_21, VALUE_22}));
            attributes.put(ATTRIBUTE3, Sets.newHashSet());
            return ImmutableMap.copyOf((Map)attributes);
        }

        public static void assertEqualsTestData(com.atlassian.crowd.embedded.api.Attributes attributes) {
            Assert.assertEquals((Object)VALUE_11, (Object)attributes.getValue(ATTRIBUTE1));
            Assert.assertEquals((Object)ImmutableSet.of((Object)VALUE_21, (Object)VALUE_22), (Object)attributes.getValues(ATTRIBUTE2));
            Assert.assertEquals(null, (Object)attributes.getValue(ATTRIBUTE3));
            Assert.assertEquals(null, (Object)attributes.getValue("unused"));
            Assert.assertThat((Object)attributes.getValues(ATTRIBUTE1), (Matcher)Matchers.contains((Object[])new String[]{VALUE_11}));
            Assert.assertThat((Object)attributes.getValues(ATTRIBUTE2), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{VALUE_21, VALUE_22}));
            Assert.assertThat((Object)attributes.getValues(ATTRIBUTE3), (Matcher)Matchers.nullValue());
            Assert.assertThat((Object)attributes.getValues("unused"), (Matcher)Matchers.nullValue());
        }
    }

    public static class Group {
        public static final String NAME = "test-group";
        public static final GroupType TYPE = GroupType.GROUP;
        public static final String DESCRIPTION = "test description";
        public static final boolean ACTIVE = true;
        public static final String NAME_1 = "name1";
        public static final String NAME_2 = "name2";
        public static final String NAME_3 = "name3";
        public static final String EXT_NAME_1 = "ext1";
        public static final String EXT_NAME_2 = "ext2";
        public static final long DIRECTORY_1 = 1L;
        public static final long DIRECTORY_2 = 2L;

        public static void assertEqualsTestGroup(com.atlassian.crowd.model.group.Group group) {
            Group.assertEqualsTestGroup(Group.getTestData().getDirectoryId(), group);
        }

        public static void assertEqualsTestGroup(long directoryId, com.atlassian.crowd.model.group.Group group) {
            com.atlassian.crowd.model.group.Group expected = Group.getTestData();
            Assert.assertEquals((Object)expected.getName(), (Object)group.getName());
            Assert.assertEquals((long)directoryId, (long)group.getDirectoryId());
            Assert.assertEquals((Object)expected.getDescription(), (Object)group.getDescription());
            Assert.assertEquals((Object)expected.getType(), (Object)group.getType());
            Assert.assertEquals((Object)expected.isActive(), (Object)group.isActive());
        }

        public static com.atlassian.crowd.model.group.Group getTestData(String groupName) {
            return Group.getGroup(groupName, 123L, true, DESCRIPTION, TYPE);
        }

        public static com.atlassian.crowd.model.group.Group getTestData() {
            return Group.getGroup(NAME, 123L, true, DESCRIPTION, TYPE);
        }

        public static com.atlassian.crowd.model.group.Group getTestData(Long directoryId) {
            return Group.getGroup(NAME, directoryId, true, DESCRIPTION, TYPE);
        }

        public static com.atlassian.crowd.model.group.Group getTestData(String groupName, Long directoryId, String externalId) {
            return Group.getGroup(groupName, directoryId, true, DESCRIPTION, TYPE, externalId);
        }

        public static com.atlassian.crowd.model.group.Group getGroup(String groupName, Long directoryId, boolean active, String description, GroupType type) {
            return Group.getGroup(groupName, directoryId, active, description, type, null);
        }

        public static List<com.atlassian.crowd.model.group.Group> getGroups() {
            return Arrays.asList(Group.getTestData(NAME_1, 1L, null), Group.getTestData(NAME_2, 1L, EXT_NAME_1), Group.getTestData(NAME_3, 1L, EXT_NAME_2), Group.getTestData(NAME_1, 2L, null), Group.getTestData(NAME_2, 2L, EXT_NAME_1));
        }

        public static com.atlassian.crowd.model.group.Group getGroup(String groupName, Long directoryId, boolean active, String description, GroupType type, String externalId) {
            com.atlassian.crowd.model.group.Group group = (com.atlassian.crowd.model.group.Group)Mockito.mock(com.atlassian.crowd.model.group.Group.class);
            Mockito.when((Object)group.getName()).thenReturn((Object)groupName);
            Mockito.when((Object)group.getDirectoryId()).thenReturn((Object)directoryId);
            Mockito.when((Object)group.getDescription()).thenReturn((Object)description);
            Mockito.when((Object)group.getType()).thenReturn((Object)type);
            Mockito.when((Object)group.isActive()).thenReturn((Object)active);
            Mockito.when((Object)group.getExternalId()).thenReturn((Object)externalId);
            return group;
        }
    }

    public static class User {
        public static final String NAME = "AUserName";
        public static final boolean ACTIVE = true;
        public static final PasswordCredential CREDENTIAL = PasswordCredential.encrypted((String)"some-password");
        public static final String DISPLAY_NAME = "TestDisplayName";
        public static final String EMAIL = "test@example.com";
        public static final String FIRST_NAME = "TestFirstName";
        public static final String LAST_NAME = "TestLastName";

        public static com.atlassian.crowd.model.user.User getTestData() {
            return User.getUser(NAME, 123L, true, FIRST_NAME, LAST_NAME, DISPLAY_NAME, EMAIL);
        }

        public static com.atlassian.crowd.model.user.User getTestData(String externalId) {
            return User.getUser(NAME, 123L, true, FIRST_NAME, LAST_NAME, DISPLAY_NAME, EMAIL, externalId);
        }

        public static com.atlassian.crowd.model.user.User getTestData(Long directoryId) {
            return User.getUser(NAME, directoryId, true, FIRST_NAME, LAST_NAME, DISPLAY_NAME, EMAIL);
        }

        public static com.atlassian.crowd.model.user.User getTestData(Long directoryId, String externalId) {
            return User.getUser(NAME, directoryId, true, FIRST_NAME, LAST_NAME, DISPLAY_NAME, EMAIL, externalId);
        }

        public static com.atlassian.crowd.model.user.User getUser(String userName, Long directoryId, boolean active, String firstName, String lastName, String displayName, String email) {
            return User.getUser(userName, directoryId, active, firstName, lastName, displayName, email, null);
        }

        public static ApplicationUser getApplicationUser(String userName, Long directoryId, boolean active, String firstName, String lastName, String displayName, String email) {
            return User.getApplicationUser(userName, directoryId, active, firstName, lastName, displayName, email, null);
        }

        public static ApplicationUser getApplicationUser(String userName, Long directoryId, boolean active, String firstName, String lastName, String displayName, String email, String externalId) {
            ApplicationUser user = (ApplicationUser)Mockito.mock(ApplicationUser.class);
            Mockito.when((Object)user.getName()).thenReturn((Object)userName);
            Mockito.when((Object)user.getDirectoryId()).thenReturn((Object)directoryId);
            Mockito.when((Object)user.isActive()).thenReturn((Object)active);
            Mockito.when((Object)user.getDisplayName()).thenReturn((Object)displayName);
            Mockito.when((Object)user.getEmailAddress()).thenReturn((Object)email);
            com.atlassian.crowd.model.user.User directoryUser = User.getUser(userName, directoryId, active, firstName, lastName, displayName, email, externalId);
            Mockito.when((Object)user.getDirectoryUser()).thenReturn((Object)directoryUser);
            return user;
        }

        public static com.atlassian.crowd.model.user.User getUser(String userName, Long directoryId, boolean active, String firstName, String lastName, String displayName, String email, String externalId) {
            com.atlassian.crowd.model.user.User user = (com.atlassian.crowd.model.user.User)Mockito.mock(com.atlassian.crowd.model.user.User.class);
            Mockito.when((Object)user.getName()).thenReturn((Object)userName);
            Mockito.when((Object)user.getDirectoryId()).thenReturn((Object)directoryId);
            Mockito.when((Object)user.isActive()).thenReturn((Object)active);
            Mockito.when((Object)user.getFirstName()).thenReturn((Object)firstName);
            Mockito.when((Object)user.getLastName()).thenReturn((Object)lastName);
            Mockito.when((Object)user.getDisplayName()).thenReturn((Object)displayName);
            Mockito.when((Object)user.getEmailAddress()).thenReturn((Object)email);
            Mockito.when((Object)user.getExternalId()).thenReturn((Object)externalId);
            return user;
        }

        public static void assertEqualsTestUser(com.atlassian.crowd.model.user.User user) {
            Assert.assertEquals((Object)NAME, (Object)user.getName());
            Assert.assertEquals((Object)true, (Object)user.isActive());
            Assert.assertEquals((Object)FIRST_NAME, (Object)user.getFirstName());
            Assert.assertEquals((Object)LAST_NAME, (Object)user.getLastName());
            Assert.assertEquals((Object)DISPLAY_NAME, (Object)user.getDisplayName());
            Assert.assertEquals((Object)EMAIL, (Object)user.getEmailAddress());
        }
    }
}

