/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.database.DuckTypeConnection;
import com.atlassian.jira.database.DuckTypeResultSet;
import com.atlassian.jira.database.ResultRow;
import com.atlassian.jira.util.DuckTypeProxyFactory;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class DuckTypePreparedStatement {
    private static final Object NULL = new Object(){

        public String toString() {
            return "NULL";
        }
    };
    private final DuckTypeConnection mockConnection;
    private final String sql;
    private List<String> batches = new ArrayList<String>();
    private Map<Integer, Object> params = new HashMap<Integer, Object>();

    public DuckTypePreparedStatement(DuckTypeConnection mockConnection, String sql) {
        this.mockConnection = mockConnection;
        this.sql = sql;
    }

    public ResultSet executeQuery() {
        return DuckTypeProxyFactory.newStrictProxyInstance(ResultSet.class, new DuckTypeResultSet(this));
    }

    public int executeUpdate() {
        String boundQuery = this.bindVariables(this.sql);
        return this.mockConnection.getUpdateResults(boundQuery);
    }

    public void close() {
    }

    public void setNull(int parameterIndex, int sqlType) {
        this.params.put(parameterIndex, NULL);
    }

    public void setBoolean(int parameterIndex, boolean x) {
        this.params.put(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) {
        this.params.put(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) {
        this.params.put(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) {
        this.params.put(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) {
        this.params.put(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) {
        this.params.put(parameterIndex, Float.valueOf(x));
    }

    public void setDouble(int parameterIndex, double x) {
        this.params.put(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) {
        this.params.put(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) {
        this.params.put(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) {
        this.params.put(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) {
        this.params.put(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) {
        this.params.put(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) {
        this.params.put(parameterIndex, x);
    }

    public void setFetchSize(int fetchSize) throws SQLException {
    }

    public void addBatch() {
        String batch = this.bindVariables(this.sql);
        this.batches.add(batch);
    }

    public int[] executeBatch() {
        int[] results = this.batches.stream().mapToInt(this.mockConnection::getUpdateResults).toArray();
        this.batches.clear();
        return results;
    }

    @Nonnull
    public Iterable<ResultRow> getExpectedResults() {
        String boundQuery = this.bindVariables(this.sql);
        return this.mockConnection.getQueryResults(boundQuery);
    }

    private String bindVariables(String sql) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (char ch : sql.toCharArray()) {
            if (ch == '?') {
                sb.append(this.getBindVariable(++count));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private String getBindVariable(int index) {
        Object val = this.params.get(index);
        if (val == null) {
            if (!this.params.containsKey(index)) {
                throw new IllegalStateException("Unbound variable #" + index);
            }
            return "NULL";
        }
        if (val instanceof String) {
            return "'" + val + "'";
        }
        return val.toString();
    }
}

