/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrlBuilder;
import com.atlassian.jira.help.MockHelpUrl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class MockHelpUrlBuilder
implements HelpUrlBuilder {
    private String prefix;
    private String suffix;
    private String url;
    private String alt;
    private String description;
    private String title;
    private String key;
    private boolean local;

    public MockHelpUrlBuilder() {
        this(null, null);
    }

    public MockHelpUrlBuilder(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public HelpUrlBuilder key(String key) {
        this.key = key;
        return this;
    }

    public HelpUrlBuilder alt(String alt) {
        this.alt = alt;
        return this;
    }

    public HelpUrlBuilder description(String description) {
        this.description = description;
        return this;
    }

    public HelpUrlBuilder title(String title) {
        this.title = title;
        return this;
    }

    public HelpUrlBuilder url(String url) {
        this.url = url;
        return this;
    }

    public HelpUrlBuilder local(boolean local) {
        this.local = local;
        return this;
    }

    public HelpUrlBuilder copy() {
        return new MockHelpUrlBuilder(this.prefix, this.suffix).key(this.key).alt(this.alt).title(this.title).url(this.url).local(this.local);
    }

    public HelpUrl build() {
        return new MockHelpUrl().setAlt(this.alt).setDescription(this.description).setTitle(this.title).setUrl(this.generateUrl()).setLocal(this.local).setKey(this.key);
    }

    public String suffix() {
        return this.suffix;
    }

    public String prefix() {
        return this.prefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockHelpUrlBuilder that = (MockHelpUrlBuilder)o;
        if (this.alt != null ? !this.alt.equals(that.alt) : that.alt != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) {
            return false;
        }
        if (this.suffix != null ? !this.suffix.equals(that.suffix) : that.suffix != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.prefix != null ? this.prefix.hashCode() : 0;
        result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.alt != null ? this.alt.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String generateUrl() {
        StringBuilder builder = new StringBuilder();
        if (this.prefix != null) {
            builder.append(this.prefix);
        }
        if (this.url != null) {
            builder.append(this.url);
        }
        if (this.suffix != null) {
            builder.append(this.suffix);
        }
        return StringUtils.stripToNull((String)builder.toString());
    }

    public static HelpUrlBuilder.Factory factory() {
        return new MockFactory();
    }

    private static class MockFactory
    implements HelpUrlBuilder.Factory {
        private MockFactory() {
        }

        public HelpUrlBuilder get(String prefix, String suffix) {
            return new MockHelpUrlBuilder(prefix, suffix);
        }
    }
}

