/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.help.MockHelpUrl;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class MockHelpUrls
implements HelpUrls {
    private Map<String, HelpUrl> urls = Maps.newHashMap();
    private HelpUrl defaultUrl;

    public MockHelpUrls(HelpUrl defaultUrl, Iterable<? extends HelpUrl> urls) {
        for (HelpUrl helpUrl : urls) {
            this.urls.put(helpUrl.getKey(), helpUrl);
        }
        this.urls.put(defaultUrl.getKey(), defaultUrl);
        this.defaultUrl = defaultUrl;
    }

    public MockHelpUrls merge(MockHelpUrls m) {
        return new MockHelpUrls(this.getDefaultUrl(), Iterables.concat(this.urls.values(), m.urls.values()));
    }

    public MockHelpUrls(HelpUrl defaultUrl, HelpUrl ... urls) {
        this(defaultUrl, Arrays.asList(urls));
    }

    public MockHelpUrls() {
        this((HelpUrl)MockHelpUrl.simpleUrl("default"), new HelpUrl[0]);
    }

    @Nonnull
    public HelpUrl getUrl(@Nonnull String key) {
        HelpUrl helpUrl = this.urls.get(key);
        return helpUrl == null ? this.defaultUrl : helpUrl;
    }

    @Nonnull
    public HelpUrl getDefaultUrl() {
        return this.defaultUrl;
    }

    @Nonnull
    public Set<String> getUrlKeys() {
        return Collections.unmodifiableSet(this.urls.keySet());
    }

    @Nonnull
    public HelpUrl getUrlForApplication(@Nonnull ApplicationKey applicationKey, @Nonnull String key) {
        return this.getUrl(key);
    }

    public Iterator<HelpUrl> iterator() {
        return Collections.unmodifiableCollection(this.urls.values()).iterator();
    }

    public MockHelpUrls defaultUrl(HelpUrl url) {
        this.defaultUrl = url;
        return this.addUrl(url);
    }

    public MockHelpUrl createDefault() {
        return this.createDefault("default");
    }

    public MockHelpUrl createDefault(String key) {
        MockHelpUrl url = MockHelpUrl.simpleUrl(key);
        this.defaultUrl(url);
        return url;
    }

    public MockHelpUrls addUrl(HelpUrl url) {
        this.urls.put(url.getKey(), url);
        return this;
    }

    public MockHelpUrl createSimpleUrl(String key) {
        MockHelpUrl url = MockHelpUrl.simpleUrl(key);
        this.addUrl(url);
        return url;
    }

    public MockHelpUrl createUrl(String key) {
        MockHelpUrl result = new MockHelpUrl().setKey(key);
        this.addUrl(result);
        return result;
    }
}

