/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.issue.fields.ProjectFieldLayoutSchemeHelper;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.project.Project;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MockProjectFieldLayoutSchemeHelper
implements ProjectFieldLayoutSchemeHelper {
    private Multimap<FieldLayout, Project> fieldLayoutProjectMapping;
    private Map<Long, List<Project>> schemeIdProjectMapping;

    public MockProjectFieldLayoutSchemeHelper() {
        HashMap backingMap = Maps.newHashMap();
        this.fieldLayoutProjectMapping = Multimaps.newSetMultimap((Map)backingMap, (Supplier)new Supplier<Set<Project>>(){

            public Set<Project> get() {
                return new LinkedHashSet<Project>();
            }
        });
        this.schemeIdProjectMapping = Maps.newHashMap();
    }

    public List<Project> getProjectsForScheme(Long schemeId) {
        return this.schemeIdProjectMapping.get(schemeId);
    }

    public Multimap<FieldLayout, Project> getProjectsForFieldLayouts(Set<FieldLayout> fieldLayouts) {
        HashMap backingMap = Maps.newHashMap();
        SetMultimap matchingFieldlayouts = Multimaps.newSetMultimap((Map)backingMap, (Supplier)new Supplier<Set<Project>>(){

            public Set<Project> get() {
                return new LinkedHashSet<Project>();
            }
        });
        for (FieldLayout fieldLayout : fieldLayouts) {
            matchingFieldlayouts.putAll((Object)fieldLayout, (Iterable)this.fieldLayoutProjectMapping.get((Object)fieldLayout));
        }
        return matchingFieldlayouts;
    }

    public List<Project> getProjectsForFieldLayout(FieldLayout fieldLayout) {
        return Lists.newArrayList((Iterable)this.fieldLayoutProjectMapping.get((Object)fieldLayout));
    }

    public MockProjectFieldLayoutSchemeHelper setProjectsForFieldLayout(FieldLayout fieldLayout, List<Project> layoutProjects) {
        this.fieldLayoutProjectMapping.putAll((Object)fieldLayout, layoutProjects);
        return this;
    }

    public MockProjectFieldLayoutSchemeHelper setProjectsForFieldLayoutScheme(Long schemeId, List<Project> projects) {
        this.schemeIdProjectMapping.put(schemeId, projects);
        return this;
    }
}

