/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.issuetype;

import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.MockIssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

public class MockIssueTypeScreenScheme
implements IssueTypeScreenScheme {
    private long id;
    private String name;
    private String description;
    private Map<String, IssueTypeScreenSchemeEntity> issueTypeIdToEntity = Maps.newHashMap();

    public Long getId() {
        return this.id;
    }

    public MockIssueTypeScreenScheme id(long id) {
        this.id = id;
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GenericValue getGenericValue() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setGenericValue(GenericValue genericValue) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void store() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void remove() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<IssueTypeScreenSchemeEntity> getEntities() {
        return this.issueTypeIdToEntity.values();
    }

    public IssueTypeScreenSchemeEntity getEntity(String issueTypeId) {
        return this.issueTypeIdToEntity.get(issueTypeId);
    }

    @Nonnull
    public FieldScreenScheme getEffectiveFieldScreenScheme(@Nonnull IssueType type) {
        IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = this.getEntity(type.getId());
        if (issueTypeScreenSchemeEntity == null) {
            issueTypeScreenSchemeEntity = this.getDefaultEntity();
        }
        return issueTypeScreenSchemeEntity.getFieldScreenScheme();
    }

    public IssueTypeScreenSchemeEntity getDefaultEntity() {
        return this.getEntity(null);
    }

    public void addEntity(IssueTypeScreenSchemeEntity entity) {
        this.issueTypeIdToEntity.put(entity.getIssueTypeId(), entity);
    }

    public void removeEntity(String issueTypeId) {
        this.issueTypeIdToEntity.remove(issueTypeId);
    }

    public boolean containsEntity(String issueTypeId) {
        return this.issueTypeIdToEntity.containsKey(issueTypeId);
    }

    public Collection<GenericValue> getProjects() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isDefault() {
        return IssueTypeScreenScheme.DEFAULT_SCHEME_ID.equals(this.getId());
    }

    private long getNextEntityId() {
        long maxId = -1L;
        for (IssueTypeScreenSchemeEntity entity : this.issueTypeIdToEntity.values()) {
            if (entity.getId() == null) continue;
            maxId = Math.max(entity.getId() & 0xFFFFFFFFL, maxId);
        }
        return this.id << 32 | maxId + 1L;
    }

    public MockIssueTypeScreenSchemeEntity createEntity(IssueType type) {
        MockIssueTypeScreenSchemeEntity entity = new MockIssueTypeScreenSchemeEntity().id(this.getNextEntityId()).issueType(type).issueTypeScreenScheme(this);
        this.addEntity(entity);
        return entity;
    }

    public MockIssueTypeScreenSchemeEntity createDefaultEntity() {
        return this.createEntity(null);
    }
}

