/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.issuetype;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.MockIssueTypeScreenScheme;
import com.atlassian.jira.project.Project;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class MockIssueTypeScreenSchemeManager
implements IssueTypeScreenSchemeManager {
    private Map<Long, IssueTypeScreenScheme> projectToScheme = Maps.newHashMap();
    private Map<Long, IssueTypeScreenScheme> idToScheme = Maps.newHashMap();

    public Collection<IssueTypeScreenScheme> getIssueTypeScreenSchemes() {
        return this.idToScheme.values();
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme(Long id) {
        return this.idToScheme.get(id);
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme(GenericValue project) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme(Project project) {
        IssueTypeScreenScheme issueTypeScreenScheme = this.projectToScheme.get(project.getId());
        if (issueTypeScreenScheme == null) {
            return this.getDefaultScheme();
        }
        return issueTypeScreenScheme;
    }

    public FieldScreenScheme getFieldScreenScheme(Issue issue) {
        IssueTypeScreenScheme issueTypeScreenScheme = this.getIssueTypeScreenScheme(issue.getProjectObject());
        IssueTypeScreenSchemeEntity entity = issueTypeScreenScheme.getEntity(issue.getIssueTypeId());
        if (entity == null) {
            entity = issueTypeScreenScheme.getEntity(null);
        }
        return entity.getFieldScreenScheme();
    }

    public Collection getIssueTypeScreenSchemeEntities(IssueTypeScreenScheme issueTypeScreenScheme) {
        return issueTypeScreenScheme.getEntities();
    }

    public MockIssueTypeScreenScheme createIssueTypeScreenScheme(Project ... projects) {
        MockIssueTypeScreenScheme scheme = new MockIssueTypeScreenScheme().id(this.getNextSchemeId());
        this.createIssueTypeScreenScheme(scheme);
        for (Project project : projects) {
            this.addSchemeAssociation(project, (IssueTypeScreenScheme)scheme);
        }
        return scheme;
    }

    public MockIssueTypeScreenScheme createDefault() {
        MockIssueTypeScreenScheme scheme = new MockIssueTypeScreenScheme().id(IssueTypeScreenScheme.DEFAULT_SCHEME_ID);
        this.createIssueTypeScreenScheme(scheme);
        return scheme;
    }

    private long getNextSchemeId() {
        if (this.projectToScheme.isEmpty()) {
            return IssueTypeScreenScheme.DEFAULT_SCHEME_ID + 1L;
        }
        long max = (Long)Ordering.natural().max(this.projectToScheme.keySet());
        if (max <= IssueTypeScreenScheme.DEFAULT_SCHEME_ID) {
            return IssueTypeScreenScheme.DEFAULT_SCHEME_ID + 1L;
        }
        return max;
    }

    public void createIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        this.idToScheme.put(issueTypeScreenScheme.getId(), issueTypeScreenScheme);
    }

    public void updateIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        this.idToScheme.put(issueTypeScreenScheme.getId(), issueTypeScreenScheme);
    }

    public void removeIssueTypeSchemeEntities(IssueTypeScreenScheme issueTypeScreenScheme) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        this.idToScheme.remove(issueTypeScreenScheme.getId());
    }

    public void createIssueTypeScreenSchemeEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void updateIssueTypeScreenSchemeEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeIssueTypeScreenSchemeEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection getIssueTypeScreenSchemes(FieldScreenScheme fieldScreenScheme) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addSchemeAssociation(GenericValue project, IssueTypeScreenScheme issueTypeScreenScheme) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addSchemeAssociation(Project project, IssueTypeScreenScheme issueTypeScreenScheme) {
        this.projectToScheme.put(project.getId(), issueTypeScreenScheme);
    }

    public void removeSchemeAssociation(GenericValue project, IssueTypeScreenScheme issueTypeScreenScheme) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeSchemeAssociation(Project project, IssueTypeScreenScheme issueTypeScreenScheme) {
        this.projectToScheme.remove(project.getId());
    }

    public Collection<GenericValue> getProjects(IssueTypeScreenScheme issueTypeScreenScheme) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void associateWithDefaultScheme(GenericValue project) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void associateWithDefaultScheme(Project project) {
        this.addSchemeAssociation(project, this.getDefaultScheme());
    }

    public IssueTypeScreenScheme getDefaultScheme() {
        return this.getIssueTypeScreenScheme(IssueTypeScreenScheme.DEFAULT_SCHEME_ID);
    }

    public void refresh() {
    }
}

