/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.junit;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.junit.rules.AvailableInContainer;
import com.atlassian.jira.mock.component.MockComponentWorker;
import com.atlassian.jira.util.dbc.Assertions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class MockComponentContainerBase {
    private final MockComponentWorker mockWorker = new MockComponentWorker();

    public <I, C extends I> MockComponentContainerBase addMockComponent(Class<I> componentInterface, C mockComponentImplementation) {
        this.mockWorker.addMock(componentInterface, mockComponentImplementation);
        return this;
    }

    public <I, C extends I> MockComponentContainerBase addMock(Class<I> componentInterface, C mockComponentImplementation) {
        return this.addMockComponent(componentInterface, mockComponentImplementation);
    }

    public void addAnnotatedMocks(Object ... testInstances) {
        for (Object testInstance : testInstances) {
            Class<?> clazz = testInstance.getClass();
            try {
                for (Field field : MockComponentContainerBase.getAllDeclaredFields(clazz)) {
                    field.setAccessible(true);
                    if (!field.isAnnotationPresent(AvailableInContainer.class)) continue;
                    AvailableInContainer annotation = field.getAnnotation(AvailableInContainer.class);
                    Object mock = annotation.instantiateMe() ? this.instantiateAndSet(testInstance, field) : field.get(testInstance);
                    Assertions.stateNotNull((String)String.format("%s is annotated with @AvailableInContainer but this field is null. Please instantiate implementation.", field.getName()), (Object)mock);
                    this.addToContainer(mock, annotation, field.getName());
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Exception while processing @AvailableInContainer test fields", e);
            }
        }
    }

    public Object instantiateAndSet(Object testInstance, Field field) {
        try {
            Constructor<?> constructor = field.getType().getConstructor(new Class[0]);
            Object mock = constructor.newInstance(new Object[0]);
            field.set(testInstance, mock);
            return mock;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot instantiate field", e);
        }
    }

    public void addToContainer(Object mock, AvailableInContainer annotation, String fieldName) {
        Class<?> componentKey;
        if (annotation.interfaceClass().equals(Object.class)) {
            List<Class<?>> interfaceClass = this.getInterfacesExcludingCrap(mock);
            if (interfaceClass.size() == 0) {
                componentKey = this.getClassExcludingCrap(mock);
            } else {
                if (interfaceClass.size() != 1) {
                    throw new IllegalStateException(String.format("%s is annotated with @AvailableInContainer without an interface key specified, but class %s does not implement exactly one interface. You must specify an interface key for this mock to avoid ambiguity", fieldName, mock.getClass()));
                }
                componentKey = interfaceClass.get(0);
            }
        } else {
            componentKey = annotation.interfaceClass();
        }
        Assertions.stateTrue((String)String.format("Error while adding mock stored in field %s to the container. Class %s does not inherit from interface %s. Please fix the interfaceClass field on the @AvailableInContainer annotation of that field", fieldName, mock.getClass(), componentKey), (boolean)componentKey.isInstance(mock));
        this.addMock(componentKey, mock);
    }

    public Class<?> getClassExcludingCrap(Object mock) {
        return Stream.iterate(mock.getClass(), Class::getSuperclass).filter(c -> !c.getName().contains("$MockitoMock$")).findFirst().get();
    }

    public List<Class<?>> getInterfacesExcludingCrap(Object mock) {
        return (List)Stream.of(mock.getClass().getInterfaces()).filter(input -> !input.getPackage().getName().startsWith("org.mockito")).collect(CollectorsUtil.toImmutableList());
    }

    public static List<Field> getAllDeclaredFields(Class clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        if (clazz != null) {
            result.addAll(MockComponentContainerBase.getAllDeclaredFields(clazz.getSuperclass()));
            result.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return result;
    }

    public MockComponentWorker getMockWorker() {
        return this.mockWorker;
    }
}

