/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.junit.extensions;

import com.atlassian.jira.cache.request.RequestCacheController;
import com.atlassian.jira.cache.request.RequestCacheFactory;
import com.atlassian.jira.cache.request.RequestCacheFactoryImpl;
import com.atlassian.jira.cache.request.RequestCacheRecorder;
import com.atlassian.jira.cache.request.RequestCacheRecorderImpl;
import java.lang.reflect.Field;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockRequestCacheFactoryExtension
implements AfterEachCallback,
BeforeEachCallback,
TestInstancePostProcessor {
    private final Logger logger = LoggerFactory.getLogger(MockRequestCacheFactoryExtension.class);
    private final RequestCacheFactoryImpl cacheFactory = new RequestCacheFactoryImpl((RequestCacheRecorder)new RequestCacheRecorderImpl());

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        RequestCacheController.startContext();
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        while (RequestCacheController.isInContext()) {
            RequestCacheController.closeContext();
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) {
        FieldUtils.getFieldsListWithAnnotation(testInstance.getClass(), Inject.class).stream().filter(field -> field.getType().equals(RequestCacheFactory.class)).forEach(field -> {
            try {
                FieldUtils.writeField((Field)field, (Object)testInstance, (Object)this.cacheFactory, (boolean)true);
            }
            catch (IllegalAccessException e) {
                this.logger.error("Failed injecting RequestCacheFactory");
                throw new RuntimeException(e);
            }
        });
    }
}

