/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.junit.rules;

import com.atlassian.jira.junit.rules.MockComponentContainer;
import com.atlassian.jira.junit.rules.MockitoContainer;
import com.atlassian.jira.web.HttpServletVariables;
import com.atlassian.jira.web.action.MockRedirectSanitiser;
import com.atlassian.jira.web.action.RedirectSanitiser;
import com.atlassian.web.servlet.api.ServletForwarder;
import javax.annotation.ParametersAreNonnullByDefault;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;

@ParametersAreNonnullByDefault
public class JiraWebActionSupportDependencies
implements TestRule {
    private final MockComponentContainer componentContainer;
    private final MockRedirectSanitiser redirectSanitizerMock;
    private final HttpServletVariables httpServletVariablesMock;
    private final ServletForwarder servletForwarderMock;

    public JiraWebActionSupportDependencies(MockComponentContainer componentContainer) {
        this.componentContainer = componentContainer;
        this.redirectSanitizerMock = new MockRedirectSanitiser();
        this.httpServletVariablesMock = (HttpServletVariables)Mockito.mock(HttpServletVariables.class);
        this.servletForwarderMock = (ServletForwarder)Mockito.mock(ServletForwarder.class);
    }

    public static JiraWebActionSupportDependencies build(MockitoContainer mockitoContainer) {
        return new JiraWebActionSupportDependencies(mockitoContainer.getMockComponentContainer());
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                JiraWebActionSupportDependencies.this.componentContainer.addMock(RedirectSanitiser.class, JiraWebActionSupportDependencies.this.redirectSanitizerMock);
                JiraWebActionSupportDependencies.this.componentContainer.addMock(HttpServletVariables.class, JiraWebActionSupportDependencies.this.httpServletVariablesMock);
                JiraWebActionSupportDependencies.this.componentContainer.addMock(ServletForwarder.class, JiraWebActionSupportDependencies.this.servletForwarderMock);
                base.evaluate();
            }
        };
    }

    public MockRedirectSanitiser getRedirectSanitizerMock() {
        return this.redirectSanitizerMock;
    }

    public HttpServletVariables getHttpServletVariablesMock() {
        return this.httpServletVariablesMock;
    }

    public ServletForwarder getServletForwarderMock() {
        return this.servletForwarderMock;
    }
}

