/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.junit.rules;

import com.atlassian.jira.mock.servlet.MockHttpServletRequest;
import com.atlassian.jira.mock.servlet.MockHttpServletResponse;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.ExecutingHttpRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.mockito.Mockito;
import webwork.action.ActionContext;

public class MockHttp<R extends HttpServletRequest, S extends HttpServletResponse>
extends TestWatcher {
    private final R mockRequest;
    private final S mockResponse;

    public static <RR extends HttpServletRequest, RS extends HttpServletResponse> MockHttp<RR, RS> withMocks(RR mockRequest, RS mockResponse) {
        return new MockHttp<RR, RS>(mockRequest, mockResponse);
    }

    public static DefaultMocks withDefaultMocks() {
        return new DefaultMocks(new MockHttpServletRequest(), new MockHttpServletResponse());
    }

    public static MockitoMocks withMockitoMocks() {
        return new MockitoMocks((HttpServletRequest)Mockito.mock(HttpServletRequest.class), (HttpServletResponse)Mockito.mock(HttpServletResponse.class));
    }

    private MockHttp(R mockRequest, S mockResponse) {
        this.mockRequest = (HttpServletRequest)Assertions.notNull((String)"mockRequest", mockRequest);
        this.mockResponse = (HttpServletResponse)Assertions.notNull((String)"mockResponse", mockResponse);
    }

    protected void starting(Description description) {
        ActionContext.setRequest(this.mockRequest);
        ActionContext.setResponse(this.mockResponse);
        ExecutingHttpRequest.set(this.mockRequest, this.mockResponse);
    }

    protected void finished(Description description) {
        ActionContext.setRequest(null);
        ActionContext.setResponse(null);
        ExecutingHttpRequest.clear();
    }

    public R mockRequest() {
        return this.mockRequest;
    }

    public S mockResponse() {
        return this.mockResponse;
    }

    public static class DefaultMocks
    extends MockHttp<MockHttpServletRequest, MockHttpServletResponse> {
        private DefaultMocks(MockHttpServletRequest mockRequest, MockHttpServletResponse mockResponse) {
            super(mockRequest, mockResponse);
        }
    }

    public static class MockitoMocks
    extends MockHttp<HttpServletRequest, HttpServletResponse> {
        private MockitoMocks(HttpServletRequest mockRequest, HttpServletResponse mockResponse) {
            super(mockRequest, mockResponse);
        }
    }
}

