/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.jira.license.MockLicensedApplications;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.OutlookDate;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MockLicenseDetails
implements LicenseDetails {
    private boolean evaluation;
    private int daysToExpiry = Integer.MAX_VALUE;
    private int daysMaintenanceExpiry = Integer.MAX_VALUE;
    private boolean developer;
    private LicensedApplications licensedApplications = new MockLicensedApplications();
    private String briefDescription = "JIRA For Unit Tests";
    private String sen = "SEN123";
    private Date maintenanceDate;
    private String licenseString;

    public int getLicenseVersion() {
        return 2;
    }

    public boolean isEntitledToSupport() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public JiraLicense getJiraLicense() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nonnull
    public LicensedApplications getLicensedApplications() {
        return this.licensedApplications;
    }

    public boolean hasApplication(@Nonnull ApplicationKey application) {
        return this.licensedApplications.getKeys().contains(application);
    }

    public MockLicenseDetails setLicensedApplications(LicensedApplications licensedApplications) {
        this.licensedApplications = licensedApplications;
        return this;
    }

    public LicenseDetails.LicenseStatusMessage getLicenseStatusMessage(I18nHelper i18n, UserManager userManager) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public LicenseDetails.LicenseStatusMessage getMaintenanceMessage(@Nonnull I18nHelper i18n, String applicationName) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getLicenseExpiryStatusMessage(@Nullable ApplicationUser user) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getLicenseExpiryStatusMessage(I18nHelper i18n, @Nullable OutlookDate ignored) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getBriefMaintenanceStatusMessage(I18nHelper i18n) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public Date getMaintenanceExpiryDate() {
        return this.maintenanceDate;
    }

    public String getMaintenanceEndString(OutlookDate outlookDate) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isUnlimitedNumberOfUsers() {
        return false;
    }

    public String getDescription() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getPartnerName() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isExpired() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getPurchaseDate(OutlookDate outlookDate) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public MockLicenseDetails setEvaluation(boolean eval) {
        this.evaluation = eval;
        return this;
    }

    public boolean isEvaluation() {
        return this.evaluation;
    }

    public boolean isStarter() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isPaidType() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isCommercial() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isPersonalLicense() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isCommunity() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isOpenSource() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isNonProfit() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isDemonstration() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isOnDemand() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isDataCenter() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isEnterpriseLicenseAgreement() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isDeveloper() {
        return this.developer;
    }

    public MockLicenseDetails setDeveloper(boolean developer) {
        this.developer = developer;
        return this;
    }

    public String getOrganisation() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getLicenseString() {
        return this.licenseString;
    }

    public boolean isMaintenanceValidForBuildDate(Date currentBuildDate) {
        return this.maintenanceDate.compareTo(currentBuildDate) >= 0;
    }

    public String getSupportEntitlementNumber() {
        return this.sen;
    }

    public Collection<LicenseDetails.LicenseContact> getContacts() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getDaysToLicenseExpiry() {
        return this.daysToExpiry;
    }

    public MockLicenseDetails setDaysToLicenseExpiry(int days) {
        this.daysToExpiry = days;
        return this;
    }

    public int getDaysToMaintenanceExpiry() {
        return this.daysMaintenanceExpiry;
    }

    public LicenseType getLicenseType() {
        return null;
    }

    @Nonnull
    public String getApplicationDescription() {
        return this.briefDescription;
    }

    public MockLicenseDetails setBriefDescription(String description) {
        this.briefDescription = description;
        return this;
    }

    public MockLicenseDetails setDaysToMaintenanceExpiry(int days) {
        this.daysMaintenanceExpiry = days;
        return this;
    }

    public MockLicenseDetails setSupportEntitlementNumber(@Nonnull String sen) {
        this.sen = sen;
        return this;
    }

    public MockLicenseDetails setMaintenanceDate(Date maintenanceDate) {
        this.maintenanceDate = maintenanceDate;
        return this;
    }

    public String toString() {
        return String.format("License[%s]", this.licensedApplications);
    }

    public MockLicenseDetails setLicenseString(String licensString) {
        this.licenseString = licensString;
        return this;
    }

    public MockLicenseDetails setLicensedApplications(ApplicationKey ... keys) {
        MockLicensedApplications mockLicensedApplications = new MockLicensedApplications(keys);
        return this.setLicensedApplications(mockLicensedApplications);
    }
}

