/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.MultiLicenseStore;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class MockMultiLicenseStore
implements MultiLicenseStore {
    private List<String> licenses;
    private String serverId;
    private String evalUser;

    public MockMultiLicenseStore() {
        this.licenses = ImmutableList.of();
    }

    public MockMultiLicenseStore(String ... license) {
        this.licenses = ImmutableList.copyOf((Object[])license);
    }

    public MockMultiLicenseStore(Iterable<? extends String> license) {
        this.licenses = ImmutableList.copyOf(license);
    }

    @Nonnull
    public List<String> retrieve() {
        return this.licenses;
    }

    public void store(@Nonnull Iterable<String> licenses) {
        this.licenses = ImmutableList.copyOf(licenses);
    }

    public MockMultiLicenseStore store(String ... licenses) {
        this.licenses = ImmutableList.copyOf((Object[])licenses);
        return this;
    }

    public MockMultiLicenseStore storeDetails(LicenseDetails ... licenses) {
        this.licenses = (List)Arrays.stream(licenses).map(LicenseDetails::getLicenseString).collect(CollectorsUtil.toImmutableList());
        return this;
    }

    public String retrieveServerId() {
        return this.serverId;
    }

    public void storeServerId(String serverId) {
        this.serverId = serverId;
    }

    public void resetOldBuildConfirmation() {
        this.evalUser = null;
    }

    public void confirmProceedUnderEvaluationTerms(String userName) {
        this.evalUser = userName;
    }

    public String getEvalUser() {
        return this.evalUser;
    }

    public void clear() {
        this.licenses = ImmutableList.of();
    }
}

