/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.local.runner;

import com.atlassian.jira.local.runner.GlobalRunNotifier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;

public class AbstractListeningRunner<R extends Class<? extends Runner>>
extends Runner {
    private final Runner delegateRunner;

    public AbstractListeningRunner(Class<?> classUnderTest, R runnerDelegateClass) {
        try {
            Constructor constructor = ((Class)runnerDelegateClass).getConstructor(Class.class);
            this.delegateRunner = (Runner)constructor.newInstance(classUnderTest);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Description getDescription() {
        return this.delegateRunner.getDescription();
    }

    public int testCount() {
        return this.delegateRunner.testCount();
    }

    public void run(RunNotifier notifier) {
        this.delegateRunner.run((RunNotifier)new ChainedRunNotifier(notifier, GlobalRunNotifier.getInstance()));
    }

    private class ChainedRunNotifier
    extends RunNotifier {
        private final RunNotifier[] delegates;

        private ChainedRunNotifier(RunNotifier ... delegates) {
            this.delegates = delegates;
        }

        public void addListener(final RunListener listener) {
            new SafeInvoker(){

                @Override
                void invoke(RunNotifier delegate) {
                    delegate.addListener(listener);
                }
            }.run();
        }

        public void removeListener(final RunListener listener) {
            new SafeInvoker(){

                @Override
                void invoke(RunNotifier delegate) {
                    delegate.removeListener(listener);
                }
            }.run();
        }

        public void fireTestRunStarted(final Description description) {
            new SafeInvoker(){

                @Override
                void invoke(RunNotifier delegate) {
                    delegate.fireTestRunStarted(description);
                }
            }.run();
        }

        public void fireTestRunFinished(final Result result) {
            new SafeInvoker(){

                @Override
                void invoke(RunNotifier delegate) {
                    delegate.fireTestRunFinished(result);
                }
            }.run();
        }

        public void fireTestStarted(final Description description) throws StoppedByUserException {
            new SafeInvoker(){

                @Override
                void invoke(RunNotifier delegate) {
                    delegate.fireTestStarted(description);
                }
            }.run();
        }

        public void fireTestFailure(final Failure failure) {
            new SafeInvoker(){

                @Override
                void invoke(RunNotifier delegate) {
                    delegate.fireTestFailure(failure);
                }
            }.run();
        }

        public void fireTestAssumptionFailed(final Failure failure) {
            new SafeInvoker(){

                @Override
                void invoke(RunNotifier delegate) {
                    delegate.fireTestAssumptionFailed(failure);
                }
            }.run();
        }

        public void fireTestIgnored(final Description description) {
            new SafeInvoker(){

                @Override
                void invoke(RunNotifier delegate) {
                    delegate.fireTestIgnored(description);
                }
            }.run();
        }

        public void fireTestFinished(final Description description) {
            new SafeInvoker(){

                @Override
                void invoke(RunNotifier delegate) {
                    delegate.fireTestFinished(description);
                }
            }.run();
        }

        public void pleaseStop() {
            new SafeInvoker(){

                @Override
                void invoke(RunNotifier delegate) {
                    delegate.pleaseStop();
                }
            }.run();
        }

        public void addFirstListener(final RunListener listener) {
            new SafeInvoker(){

                @Override
                void invoke(RunNotifier delegate) {
                    delegate.addFirstListener(listener);
                }
            }.run();
        }

        private abstract class SafeInvoker {
            private SafeInvoker() {
            }

            void run() {
                for (RunNotifier delegate : ChainedRunNotifier.this.delegates) {
                    try {
                        this.invoke(delegate);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            abstract void invoke(RunNotifier var1);
        }
    }
}

