/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import com.atlassian.jira.appconsistency.integrity.amendment.Amendment;
import com.google.common.base.Preconditions;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class AmendmentMatchers {
    private AmendmentMatchers() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static Matcher<Amendment> isError() {
        return new TypeSafeMatcher<Amendment>(){

            protected boolean matchesSafely(Amendment item) {
                return item.isError();
            }

            public void describeTo(Description description) {
                description.appendText("Should be error.");
            }
        };
    }

    public static Matcher<Amendment> isCorrection() {
        return new TypeSafeMatcher<Amendment>(){

            protected boolean matchesSafely(Amendment item) {
                return item.isCorrection();
            }

            public void describeTo(Description description) {
                description.appendText("Should be correction.");
            }
        };
    }

    public static Matcher<Amendment> withMessage(final String message) {
        Preconditions.checkNotNull((Object)message);
        return new TypeSafeMatcher<Amendment>(){

            protected boolean matchesSafely(Amendment item) {
                return message.equals(item.getMessage());
            }

            public void describeTo(Description description) {
                description.appendText("Message expected to be: " + message);
            }
        };
    }
}

