/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import io.atlassian.fugue.Either;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public final class EitherMatchers {
    private EitherMatchers() {
    }

    public static <L, R> Matcher<Either<L, R>> left() {
        return EitherMatchers.left(Matchers.anything());
    }

    public static <L, R> Matcher<Either<L, R>> left(L item) {
        return EitherMatchers.left(Matchers.equalTo(item));
    }

    public static <L, R> Matcher<Either<L, R>> left(Matcher<? super L> matcher) {
        return new LeftMatcher(matcher);
    }

    public static <L, R> Matcher<Either<L, R>> right() {
        return EitherMatchers.right(Matchers.anything());
    }

    public static <L, R> Matcher<Either<L, R>> right(R item) {
        return EitherMatchers.right(Matchers.equalTo(item));
    }

    public static <L, R> Matcher<Either<L, R>> right(Matcher<? super R> matcher) {
        return new RightMatcher(matcher);
    }

    private static class LeftMatcher<L, R>
    extends TypeSafeDiagnosingMatcher<Either<L, R>> {
        private Matcher<? super L> matcher;

        private LeftMatcher(Matcher<? super L> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Either<L, R> item, Description mismatchDescription) {
            if (!item.isLeft()) {
                mismatchDescription.appendText("RIGHT[").appendValue(item.right().get()).appendText("]");
                return false;
            }
            if (!this.matcher.matches(item.left().get())) {
                mismatchDescription.appendText("LEFT[");
                this.describeMismatch(item.left().get(), mismatchDescription);
                mismatchDescription.appendText("]");
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("LEFT[").appendDescriptionOf(this.matcher).appendText("]");
        }
    }

    private static class RightMatcher<L, R>
    extends TypeSafeDiagnosingMatcher<Either<L, R>> {
        private Matcher<? super R> matcher;

        private RightMatcher(Matcher<? super R> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Either<L, R> item, Description mismatchDescription) {
            if (!item.isRight()) {
                mismatchDescription.appendText("LEFT[").appendValue(item.left().get()).appendText("]");
                return false;
            }
            if (!this.matcher.matches(item.right().get())) {
                mismatchDescription.appendText("RIGHT[");
                this.matcher.describeMismatch(item.right().get(), mismatchDescription);
                mismatchDescription.appendText("]");
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText("RIGHT[").appendDescriptionOf(this.matcher).appendText("]");
        }
    }
}

