/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import com.atlassian.jira.util.RuntimeIOException;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class FileMatchers {
    private FileMatchers() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static Matcher<File> exists() {
        return new TypeSafeMatcher<File>(){
            public File testedFile;

            protected boolean matchesSafely(File file) {
                this.testedFile = file;
                return file.exists();
            }

            public void describeTo(Description description) {
                description.appendText("that file ");
                description.appendValue((Object)this.testedFile);
                description.appendText(" exists");
            }
        };
    }

    public static Matcher<File> isFile() {
        return new TypeSafeMatcher<File>(){
            public File testedFile;

            protected boolean matchesSafely(File file) {
                this.testedFile = file;
                return file.isFile();
            }

            public void describeTo(Description description) {
                description.appendText("that file ");
                description.appendValue((Object)this.testedFile);
                description.appendText(" is a regular file");
            }
        };
    }

    public static Matcher<File> isDirectory() {
        return new TypeSafeMatcher<File>(){
            public File testedFile;

            protected boolean matchesSafely(File file) {
                this.testedFile = file;
                return file.isDirectory();
            }

            public void describeTo(Description description) {
                description.appendText("that file ");
                description.appendValue((Object)this.testedFile);
                description.appendText(" is a directory");
            }
        };
    }

    public static Matcher<File> isEmptyDirectory() {
        return new TypeSafeMatcher<File>(){
            private File testedFile;

            protected boolean matchesSafely(File file) {
                this.testedFile = file;
                return file.isDirectory() && this.isEmpty(file);
            }

            private boolean isEmpty(File file) {
                File[] files = file.listFiles();
                return files == null || files.length == 0;
            }

            public void describeTo(Description description) {
                description.appendText("that file ");
                description.appendValue((Object)this.testedFile);
                description.appendText(" is an empty directory");
            }
        };
    }

    public static Matcher<File> named(final String name) {
        return new TypeSafeMatcher<File>(){

            public boolean matchesSafely(File item) {
                return item.getName().equals(name);
            }

            public void describeTo(Description description) {
                description.appendText("a file named ").appendValue((Object)name);
            }

            public void describeMismatchSafely(Description description, File item) {
                description.appendText("a file named ").appendValue((Object)name).appendText(" in ").appendValue((Object)item.getParentFile());
            }
        };
    }

    public static Matcher<File> hasContent(final String content) {
        return new TypeSafeMatcher<File>(){

            protected boolean matchesSafely(File file) {
                String fileContent = this.getFileContent(file);
                return fileContent.equals(content);
            }

            private String getFileContent(File file) {
                String fileContent;
                try {
                    fileContent = FileUtils.readFileToString((File)file, (String)"UTF-8");
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
                return fileContent;
            }

            public void describeTo(Description description) {
                description.appendText("got file with content ").appendValue((Object)content);
            }

            protected void describeMismatchSafely(File item, Description mismatchDescription) {
                mismatchDescription.appendText("file with content ").appendValue((Object)this.getFileContent(item));
            }
        };
    }

    public static Matcher<File> sameContents(final File expected) {
        return new TypeSafeMatcher<File>(){

            protected boolean matchesSafely(File item) {
                try {
                    return Files.equal((File)expected, (File)item);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public void describeTo(Description description) {
                description.appendText("file with same contents as " + expected);
            }

            protected void describeMismatchSafely(File item, Description mismatchDescription) {
                mismatchDescription.appendText(String.format("content of '%s' not the same as '%s'.", item, expected));
            }
        };
    }

    public static Matcher<File> sameContents(final InputStream expected) {
        return new TypeSafeMatcher<File>(){

            protected boolean matchesSafely(File item) {
                boolean bl;
                FileInputStream actual = new FileInputStream(item);
                try {
                    bl = IOUtils.contentEquals((InputStream)expected, (InputStream)actual);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            actual.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                actual.close();
                return bl;
            }

            public void describeTo(Description description) {
                description.appendText("file with same contents as " + expected);
            }

            protected void describeMismatchSafely(File item, Description mismatchDescription) {
                mismatchDescription.appendText(String.format("content of '%s' not the same as '%s'.", item, expected));
            }
        };
    }
}

