/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class HasSubsequenceMatcher<T>
extends TypeSafeDiagnosingMatcher<List<T>> {
    private final List<T> expectedElements;

    HasSubsequenceMatcher(List<T> expectedElements) {
        this.expectedElements = expectedElements;
    }

    protected boolean matchesSafely(List<T> items, Description mismatchDescription) {
        boolean hasSubsequence;
        boolean bl = hasSubsequence = Collections.indexOfSubList(items, this.expectedElements) != -1;
        if (!hasSubsequence) {
            mismatchDescription.appendText("input was ").appendValueList("[", ",", "]", items);
        }
        return hasSubsequence;
    }

    public void describeTo(Description description) {
        description.appendText("looking for subsequence: ").appendValueList("[", ", ", "]", this.expectedElements);
    }

    public static <U> Matcher<List<U>> hasSubsequence(List<U> items) {
        return new HasSubsequenceMatcher<U>(items);
    }

    @SafeVarargs
    public static <U> Matcher<List<U>> hasSubsequenceOf(U ... items) {
        return HasSubsequenceMatcher.hasSubsequence(ImmutableList.copyOf((Object[])items));
    }
}

