/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.Serializable;
import java.util.Objects;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class IssueMatchers {
    private IssueMatchers() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static Matcher<Issue> issueWithId(Long id) {
        Assertions.notNull((String)"id", (Object)id);
        return new IssueFieldMatcher<Long>("id", Issue::getId, id);
    }

    public static Matcher<Issue> issueWithKey(String key) {
        Assertions.notNull((String)"key", (Object)key);
        return new IssueFieldMatcher<String>("key", Issue::getKey, key);
    }

    public static Matcher<Issue> issueWithPriority(Priority priority) {
        Assertions.notNull((String)"priority", (Object)priority);
        return new IssueFieldMatcher<Priority>("priority", Issue::getPriority, priority);
    }

    public static Matcher<MutableIssue> issueWithIdAndPriority(long id, Priority priority) {
        Assertions.notNull((String)"priority", (Object)priority);
        return new And(IssueMatchers.issueWithId(id), IssueMatchers.issueWithPriority(priority));
    }

    private static class IssueFieldMatcher<T>
    extends TypeSafeMatcher<Issue> {
        private final String fieldName;
        private final Function<Issue, T> valueGetter;
        private final T expected;

        IssueFieldMatcher(String fieldName, Function<Issue, T> valueGetter, T expected) {
            this.fieldName = fieldName;
            this.valueGetter = valueGetter;
            this.expected = expected;
        }

        protected boolean matchesSafely(Issue issue) {
            return Objects.equals(this.valueGetter.apply((Object)issue), this.expected);
        }

        public void describeTo(Description description) {
            description.appendText(String.format("Issue with field " + this.fieldName, new Object[0])).appendValue(this.expected);
        }
    }

    private static class And
    extends BaseMatcher
    implements Serializable {
        private final Matcher m1;
        private final Matcher m2;

        public And(Matcher<?> m1, Matcher<?> m2) {
            this.m1 = m1;
            this.m2 = m2;
        }

        public boolean matches(Object actual) {
            return this.m1.matches(actual) && this.m2.matches(actual);
        }

        public void describeTo(Description description) {
            description.appendText("and(");
            this.m1.describeTo(description);
            description.appendText(", ");
            this.m2.describeTo(description);
            description.appendText(")");
        }
    }
}

