/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Pair;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.TypeSafeMatcher;

public final class MapMatchers {
    private MapMatchers() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static <K, V> Matcher<Map<K, V>> isSingletonMap(final K expectedKey, final V expectedValue) {
        return new TypeSafeMatcher<Map<K, V>>(){

            protected boolean matchesSafely(Map<K, V> map) {
                return map.size() == 1 && map.containsKey(expectedKey) && map.containsValue(expectedValue);
            }

            public void describeTo(Description description) {
                description.appendText("a map with exactly one entry: [").appendValue(expectedKey).appendText(", ").appendValue(expectedValue).appendText("]");
            }
        };
    }

    public static <K> Matcher<Map<? extends K, ?>> hasKeyThat(final Matcher<K> keyMatcher) {
        return new TypeSafeMatcher<Map<? extends K, ?>>(){

            protected boolean matchesSafely(Map<? extends K, ?> map) {
                return map.keySet().stream().anyMatch(arg_0 -> ((Matcher)keyMatcher).matches(arg_0));
            }

            public void describeTo(Description description) {
                description.appendText("a map containing key that ").appendDescriptionOf((SelfDescribing)keyMatcher);
            }
        };
    }

    public static <K, V> OrderedMapMatcher<K, V> orderedMap(SortedMap<K, V> map) {
        return OrderedMapMatcher.orderedMap(map);
    }

    public static <K, V> OrderedMapMatcher<K, V> orderedMap(K key1, V value1) {
        return OrderedMapMatcher.orderedMap(key1, value1);
    }

    public static <K, V> OrderedMapMatcher<K, V> orderedMap(K key1, V value1, K key2, V value2) {
        return OrderedMapMatcher.orderedMap(key1, value1, key2, value2);
    }

    public static <K, V> OrderedMapMatcher<K, V> orderedMap(K key1, V value1, K key2, V value2, K key3, V value3) {
        return OrderedMapMatcher.orderedMap(key1, value1, key2, value2, key3, value3);
    }

    public static <K, V> Matcher<Map<K, V>> isMapOf(K key1, V value1, K key2, V value2) {
        return Matchers.equalTo((Object)ImmutableMap.of(key1, value1, key2, value2));
    }

    public static <K, V> Matcher<Map<K, V>> hasEntries(final Map<K, V> expectedMap) {
        return new TypeSafeMatcher<Map<K, V>>(){

            protected boolean matchesSafely(Map<K, V> item) {
                return expectedMap.entrySet().stream().allMatch(kv -> {
                    Object v = item.get(kv.getKey());
                    return v != null && v.equals(expectedMap.get(kv.getKey()));
                });
            }

            public void describeTo(Description description) {
                description.appendText("Expected map ").appendValue((Object)expectedMap);
            }
        };
    }

    public static <K, V> Matcher<Map<K, V>> isEmptyMap() {
        return new TypeSafeMatcher<Map<K, V>>(){

            protected boolean matchesSafely(Map<K, V> theMap) {
                return theMap.isEmpty();
            }

            public void describeTo(Description description) {
                description.appendText("Expected an empty map.");
            }
        };
    }

    public static <K, V> Matcher<Map<K, V>> isMapWithSize(final int size) {
        return new TypeSafeMatcher<Map<K, V>>(){

            protected boolean matchesSafely(Map<K, V> theMap) {
                return theMap.size() == size;
            }

            public void describeTo(Description description) {
                description.appendText("Expected a map with " + size + " entries.");
            }
        };
    }

    public static class OrderedMapMatcher<K, V>
    extends TypeSafeDiagnosingMatcher<Map<K, V>> {
        private List<Pair<K, V>> pairs;

        public static <K, V> OrderedMapMatcher<K, V> orderedMap(SortedMap<K, V> map) {
            return new OrderedMapMatcher<K, V>(OrderedMapMatcher.toList(map));
        }

        public static <K, V> OrderedMapMatcher<K, V> orderedMap(Iterable<Pair<K, V>> pairs) {
            return new OrderedMapMatcher<K, V>(pairs);
        }

        public static <K, V> OrderedMapMatcher<K, V> orderedMap(K key1, V value1) {
            return OrderedMapMatcher.orderedMap(ImmutableList.of((Object)Pair.pair(key1, value1)));
        }

        public static <K, V> OrderedMapMatcher<K, V> orderedMap(K key1, V value1, K key2, V value2) {
            return OrderedMapMatcher.orderedMap(ImmutableList.of((Object)Pair.pair(key1, value1), (Object)Pair.pair(key2, value2)));
        }

        public static <K, V> OrderedMapMatcher<K, V> orderedMap(K key1, V value1, K key2, V value2, K key3, V value3) {
            return OrderedMapMatcher.orderedMap(ImmutableList.of((Object)Pair.pair(key1, value1), (Object)Pair.pair(key2, value2), (Object)Pair.pair(key3, value3)));
        }

        private OrderedMapMatcher(Iterable<Pair<K, V>> pairs) {
            this.pairs = ImmutableList.copyOf(pairs);
        }

        protected boolean matchesSafely(Map<K, V> actual, Description description) {
            List<Pair<K, V>> actualPairs = OrderedMapMatcher.toList(actual);
            if (actualPairs.equals(this.pairs)) {
                return true;
            }
            description.appendValue(actualPairs);
            return false;
        }

        public void describeTo(Description description) {
            description.appendValue(this.pairs);
        }

        private static <K, V> List<Pair<K, V>> toList(Map<? extends K, ? extends V> map) {
            return map.entrySet().stream().map(e -> Pair.pair(e.getKey(), e.getValue())).collect(Collectors.toList());
        }
    }
}

