/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class NioFileMatchers {
    private NioFileMatchers() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static Matcher<Path> exists() {
        return new TypeSafeMatcher<Path>(){
            private Path testedFile;

            protected boolean matchesSafely(Path file) {
                this.testedFile = file;
                return Files.exists(file, new LinkOption[0]);
            }

            public void describeTo(Description description) {
                description.appendText("that file ");
                description.appendValue((Object)this.testedFile);
                description.appendText(" exists");
            }
        };
    }
}

