/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class OptionalMatchers {
    public static <T> Matcher<Optional<T>> none() {
        return new NoneMatchers();
    }

    public static <T> Matcher<Optional<T>> some(Matcher<? super T> matcher) {
        return new SomeMatchers<T>(matcher);
    }

    public static <T> Matcher<Optional<T>> some(T value) {
        return new SomeMatchers(Matchers.equalTo(value));
    }

    private static class NoneMatchers<T>
    extends TypeSafeDiagnosingMatcher<Optional<T>> {
        private NoneMatchers() {
        }

        protected boolean matchesSafely(Optional<T> item, Description mismatchDescription) {
            if (item.isPresent()) {
                mismatchDescription.appendValue(item);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendValue(Optional.empty());
        }
    }

    private static class SomeMatchers<T>
    extends TypeSafeDiagnosingMatcher<Optional<T>> {
        private final Matcher<? super T> matcher;

        private SomeMatchers(Matcher<? super T> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Optional<T> item, Description mismatchDescription) {
            if (!item.isPresent()) {
                mismatchDescription.appendValue(item);
                return false;
            }
            if (this.matcher.matches(item.get())) {
                return true;
            }
            mismatchDescription.appendText("some(");
            this.matcher.describeMismatch(item.get(), mismatchDescription);
            mismatchDescription.appendText(")");
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("some(").appendDescriptionOf(this.matcher).appendText(")");
        }
    }
}

