/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers;

import java.lang.reflect.Field;
import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public final class ReflectionMatchers {
    private ReflectionMatchers() {
    }

    public static <T> Matcher<? super T> propertiesMatcher(final Map<String, Matcher<Object>> values) {
        return new BaseMatcher<T>(){

            public void describeTo(Description description) {
                description.appendValue((Object)("object with properties=" + values));
            }

            public void describeMismatch(Object item, Description mismatchDescription) {
                mismatchDescription.appendText("was ");
                mismatchDescription.appendText(item.getClass().getSimpleName() + "{");
                String sep = "";
                for (String property : values.keySet()) {
                    mismatchDescription.appendText(sep);
                    mismatchDescription.appendText(property + "=" + this.getFieldFromBean(item, property));
                    sep = ", ";
                }
                mismatchDescription.appendText("}");
            }

            public boolean matches(Object item) {
                for (Map.Entry property : values.entrySet()) {
                    Object value = this.getFieldFromBean(item, (String)property.getKey());
                    if (((Matcher)property.getValue()).matches(value)) continue;
                    return false;
                }
                return true;
            }

            private Object getFieldFromBean(Object item, String fieldName) {
                try {
                    Field declaredField = item.getClass().getDeclaredField(fieldName);
                    declaredField.setAccessible(true);
                    Object value = declaredField.get(item);
                    return value;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

