/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.matchers.auditing;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class AuditMatchers {
    public static BaseMatcher<AuditEvent> hasAffectedObject(@Nonnull Matcher<AuditResource> itemMatcher) {
        return new FeatureMatcher<AuditEvent, Iterable<AuditResource>>(Matchers.hasItem(itemMatcher), "affectedObjects to be", "affectedObjects was:"){

            protected Iterable<AuditResource> featureValueOf(AuditEvent actual) {
                return actual.getAffectedObjects();
            }
        };
    }

    public static <T extends Iterable<?>> Matcher<AuditEvent> affectedObjects(Matcher<T> collectionMatcher) {
        return new FeatureMatcher<AuditEvent, T>(collectionMatcher, "affectedObjects to be", "affectedObjects was:"){

            protected T featureValueOf(AuditEvent actual) {
                return StreamSupport.stream(actual.getAffectedObjects().spliterator(), false).collect(Collectors.toList());
            }
        };
    }

    public static BaseMatcher<AuditEvent> hasExtraAttribute(@Nonnull String name, @Nullable String value) {
        return AuditMatchers.hasExtraAttribute(name, (Matcher<String>)Matchers.equalTo((Object)value));
    }

    public static BaseMatcher<AuditEvent> hasExtraAttribute(final @Nonnull String name, @Nonnull Matcher<String> itemMatcher) {
        String featureDescription = String.format("extra attribute '%s' to be", name);
        return new FeatureMatcher<AuditEvent, String>(itemMatcher, featureDescription, ""){

            protected String featureValueOf(AuditEvent actual) {
                return actual.getExtraAttributeByKey(name).orElse(null);
            }
        };
    }

    public static BaseMatcher<AuditEvent> hasChangedValue(@Nonnull Matcher<ChangedValue> itemMatcher) {
        return new FeatureMatcher<AuditEvent, Iterable<ChangedValue>>(Matchers.hasItem(itemMatcher), "changedValues to be", "changedValues"){

            protected Iterable<ChangedValue> featureValueOf(AuditEvent actual) {
                return actual.getChangedValues();
            }
        };
    }

    public static <T extends Iterable<?>> Matcher<AuditEvent> changedValues(Matcher<T> collectionMatcher) {
        return new FeatureMatcher<AuditEvent, T>(collectionMatcher, "changedValues to be", "changedValues was:"){

            protected T featureValueOf(AuditEvent actual) {
                return StreamSupport.stream(actual.getChangedValues().spliterator(), false).collect(Collectors.toList());
            }
        };
    }

    public static BaseMatcher<AuditEvent> hasAuditType(@Nonnull Matcher<AuditType> auditTypeMatcher) {
        return new FeatureMatcher<AuditEvent, AuditType>(auditTypeMatcher, "expected AuditType category", "AuditingCategory from categoryI18nKey"){

            protected AuditType featureValueOf(AuditEvent actual) {
                return AuditEntitiesUtils.newAuditType((CoverageArea)actual.getArea(), (String)actual.getCategoryI18nKey(), (String)actual.getActionI18nKey(), (CoverageLevel)actual.getLevel());
            }
        };
    }

    public static BaseMatcher<AuditType> hasActionI18nKey(@Nullable String actionI18nKey) {
        return AuditMatchers.hasActionI18nKey((Matcher<String>)Matchers.equalTo((Object)actionI18nKey));
    }

    public static BaseMatcher<AuditType> hasActionI18nKey(@Nonnull Matcher<String> actionMatcher) {
        return new FeatureMatcher<AuditType, String>(actionMatcher, "expected AuditType actionI18nKey", "actionI18nKey"){

            protected String featureValueOf(AuditType actual) {
                return actual.getActionI18nKey();
            }
        };
    }

    public static Matcher<AuditType> hasCoverageLevel(CoverageLevel level) {
        return AuditMatchers.hasCoverageLevel((Matcher<CoverageLevel>)Matchers.equalTo((Object)level));
    }

    public static Matcher<AuditType> hasCoverageLevel(@Nonnull Matcher<CoverageLevel> actionMatcher) {
        return new FeatureMatcher<AuditType, CoverageLevel>(actionMatcher, "expected AuditType coverageLevel", "coverageLevel"){

            protected CoverageLevel featureValueOf(AuditType actual) {
                return actual.getLevel();
            }
        };
    }
}

