/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.ArchiveException;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueImpl;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MockIssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.UpdateIssueRequest;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.mock.MockProjectManager;
import com.atlassian.jira.mock.issue.MockIssue;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class MockIssueManager
implements IssueManager {
    Map<Long, Issue> issues;
    Map versions;
    Map issueVersions;
    boolean editable;
    boolean editableAfterAction;
    private Map<String, Long> movedIssueKeys = new HashMap<String, Long>();

    public MockIssueManager() {
        this.issues = new HashMap<Long, Issue>();
        this.versions = new HashMap();
        this.issueVersions = new HashMap();
    }

    public GenericValue getIssue(Long id) throws DataAccessException {
        MutableIssue issue = this.getIssueObject(id);
        if (issue == null) {
            return null;
        }
        return issue.getGenericValue();
    }

    public GenericValue getIssue(String key) throws GenericEntityException {
        Issue movedIssue = this.findMovedIssue(key);
        if (movedIssue != null) {
            return movedIssue.getGenericValue();
        }
        for (Issue issue : this.issues.values()) {
            if (!key.equals(issue.getKey())) continue;
            return issue.getGenericValue();
        }
        return null;
    }

    public boolean isExistingIssueKey(String issueKey) throws GenericEntityException {
        return this.getIssue(issueKey) != null;
    }

    public List getIssues(Collection ids) {
        ArrayList<GenericValue> issues = new ArrayList<GenericValue>();
        for (Object id1 : ids) {
            Long id = (Long)id1;
            issues.add(this.getIssue(id));
        }
        return issues;
    }

    public GenericValue getIssueByWorkflow(Long wfid) throws GenericEntityException {
        List values = CoreFactory.getGenericDelegator().findByAnd("Issue", (Map)FieldMap.build((String)"workflowId", (Object)wfid));
        return EntityUtil.getOnly((List)values);
    }

    public MutableIssue getIssueObjectByWorkflow(Long workflowId) throws GenericEntityException {
        return this.getIssueObject(this.getIssueByWorkflow(workflowId));
    }

    private MutableIssue getIssueObject(GenericValue issueGV) {
        return new IssueImpl(issueGV, (IssueManager)this, MockIssueFactory.getProjectManager(), MockIssueFactory.getVersionManager(), MockIssueFactory.getIssueSecurityLevelManager(), MockIssueFactory.getConstantsManager(), MockIssueFactory.getSubTaskManager(), MockIssueFactory.getAttachmentManager(), MockIssueFactory.getLabelManager(), MockIssueFactory.getProjectComponentManager(), MockIssueFactory.getUserManager(), MockIssueFactory.getJiraAuthenticationContext(), MockIssueFactory.getIssueArchiveHelper());
    }

    public MutableIssue getIssueObject(Long id) throws DataAccessException {
        Issue issue = this.issues.get(id);
        if (issue == null) {
            return null;
        }
        if (issue instanceof MockIssue) {
            return (MockIssue)issue;
        }
        return this.getIssueObject(issue.getGenericValue());
    }

    public MutableIssue getIssueObject(String key) throws DataAccessException {
        Issue movedIssue = this.findMovedIssue(key);
        if (movedIssue != null) {
            return (MutableIssue)movedIssue;
        }
        Issue issue = null;
        for (Issue i : this.issues.values()) {
            if (!key.equals(i.getKey())) continue;
            issue = i;
            break;
        }
        if (issue == null) {
            return null;
        }
        return new IssueImpl(issue.getGenericValue(), (IssueManager)this, MockIssueFactory.getProjectManager(), MockIssueFactory.getVersionManager(), MockIssueFactory.getIssueSecurityLevelManager(), MockIssueFactory.getConstantsManager(), MockIssueFactory.getSubTaskManager(), MockIssueFactory.getAttachmentManager(), MockIssueFactory.getLabelManager(), MockIssueFactory.getProjectComponentManager(), MockIssueFactory.getUserManager(), MockIssueFactory.getJiraAuthenticationContext(), MockIssueFactory.getIssueArchiveHelper());
    }

    public MutableIssue getIssueByKeyIgnoreCase(String key) throws DataAccessException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public MutableIssue getIssueByCurrentKey(String key) throws DataAccessException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<Issue> getIssueObjects(Collection<Long> ids) {
        return this.issues.entrySet().stream().filter(entry -> ids.contains(entry.getKey())).map(entry -> (Issue)entry.getValue()).collect(Collectors.toList());
    }

    public List getEntitiesByIssue(String relationName, GenericValue issue) throws GenericEntityException {
        throw new UnsupportedOperationException();
    }

    public List getEntitiesByIssueObject(String relationName, Issue issue) throws GenericEntityException {
        return new ArrayList();
    }

    public List getIssuesByEntity(String relationName, GenericValue entity) throws GenericEntityException {
        throw new UnsupportedOperationException();
    }

    public List<Issue> getIssueObjectsByEntity(String relationName, GenericValue entity) throws GenericEntityException {
        throw new UnsupportedOperationException();
    }

    public Set<String> getAllIssueKeys(Long issueId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Issue createIssueObject(String remoteUserName, Map<String, Object> fields) throws CreateException {
        throw new UnsupportedOperationException();
    }

    public Issue createIssueObject(ApplicationUser remoteUser, Map<String, Object> fields) throws CreateException {
        throw new UnsupportedOperationException();
    }

    public GenericValue createIssue(String remoteUserName, Map fields) {
        throw new UnsupportedOperationException();
    }

    public GenericValue createIssue(ApplicationUser remoteUser, Map fields) throws CreateException {
        throw new UnsupportedOperationException();
    }

    public GenericValue createIssue(ApplicationUser remoteUser, Issue issue) throws CreateException {
        throw new UnsupportedOperationException();
    }

    public Issue createIssueObject(ApplicationUser remoteUser, Issue issue) throws CreateException {
        throw new UnsupportedOperationException();
    }

    public Issue updateIssue(ApplicationUser user, MutableIssue issue, UpdateIssueRequest updateIssueRequest) {
        this.issues.put(issue.getId(), (Issue)issue);
        return issue;
    }

    public Issue updateIssue(ApplicationUser user, MutableIssue issue, EventDispatchOption eventDispatchOption, boolean sendMail) {
        return this.updateIssue(null, issue, null);
    }

    public Issue archiveIssue(ApplicationUser user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    public Issue restoreIssue(ApplicationUser user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws ArchiveException {
        throw new UnsupportedOperationException();
    }

    public void deleteIssue(ApplicationUser user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        this.issues.remove(issue.getId());
    }

    public void deleteIssue(ApplicationUser user, MutableIssue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        throw new UnsupportedOperationException();
    }

    public void deleteIssueNoEvent(Issue issue) throws RemoveException {
        throw new UnsupportedOperationException();
    }

    public void deleteIssueNoEvent(MutableIssue issue) throws RemoveException {
        throw new UnsupportedOperationException();
    }

    public List getProjectIssues(GenericValue project) throws GenericEntityException {
        throw new UnsupportedOperationException();
    }

    public boolean isEditable(Issue issue) {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable(Issue issue, ApplicationUser user) {
        return this.editable;
    }

    public void setEditableAfterAction(boolean editableAfterAction) {
        this.editableAfterAction = editableAfterAction;
    }

    public boolean isEditable(@Nonnull Issue issue, @Nonnull String nextStatusId) {
        return this.editableAfterAction;
    }

    public Collection getIssueIdsForProject(Long projectId) throws GenericEntityException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public long getIssueCountForProject(Long projectId) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public long getIssueCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean atLeastOneIssueExists() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean hasUnassignedIssues() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public long getUnassignedIssueCount() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public Issue findMovedIssue(String oldIssueKey) {
        return this.getIssueObject(this.movedIssueKeys.get(oldIssueKey));
    }

    public void recordMovedIssueKey(Issue oldIssue) {
        this.movedIssueKeys.put(oldIssue.getKey(), oldIssue.getId());
    }

    @Nonnull
    public Set<Pair<Long, String>> getProjectIssueTypePairsByKeys(@Nonnull Set<String> issueKeys) {
        return new HashSet<Pair<Long, String>>();
    }

    @Nonnull
    public Set<Pair<Long, String>> getProjectIssueTypePairsByIds(@Nonnull Set<Long> issueIds) {
        return new HashSet<Pair<Long, String>>();
    }

    @Nonnull
    public Set<String> getKeysOfMissingIssues(@Nonnull Set<String> issueKeys) {
        return new HashSet<String>();
    }

    @Nonnull
    public Set<Long> getIdsOfMissingIssues(@Nonnull Set<Long> issueIds) {
        return new HashSet<Long>();
    }

    public List<Issue> getVotedIssuesOverrideSecurity(ApplicationUser user) {
        throw new UnsupportedOperationException();
    }

    public List<Issue> getVotedIssues(ApplicationUser user) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<ApplicationUser> getWatchers(Issue issue) {
        throw new UnsupportedOperationException();
    }

    public List<ApplicationUser> getWatchersFor(Issue issue) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<Issue> getWatchedIssues(ApplicationUser user) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<Issue> getWatchedIssuesOverrideSecurity(ApplicationUser user) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addIssue(GenericValue issueGV) {
        this.addIssue((MutableIssue)new IssueImpl(issueGV, (IssueManager)this, (ProjectManager)new MockProjectManager(), null, null, null, null, null, null, null, null, null, null));
    }

    public void addIssue(MutableIssue issue) {
        this.issues.put(issue.getId(), (Issue)issue);
    }

    public void addVersion(GenericValue version) throws GenericEntityException {
        this.versions.put(version.getLong("id"), version);
        GenericValue issue = this.getIssue(version.getLong("issue"));
        this.getEntitiesByIssue("IssueVersion", issue).add(version);
    }

    public List execute(SearchRequest searchRequest, ApplicationUser searcher) throws SearchException {
        throw new UnsupportedOperationException();
    }

    public void refresh() {
    }

    public void refresh(GenericValue issue) {
    }

    public long getCacheHitsCount() {
        return 0L;
    }

    public long getCacheMissCount() {
        return 0L;
    }

    public void resetCacheStats() {
    }

    public long getCacheMaxSize() {
        return 0L;
    }

    public void setCacheMaxSize(long maxSize) {
    }

    public long getCacheSize() {
        return 0L;
    }

    public void refreshParents(String associationName, GenericValue child) throws GenericEntityException {
        throw new UnsupportedOperationException();
    }
}

