/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.issue.index;

import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.index.AccumulatingResultBuilder;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.UnmanagedIndexSearcher;
import com.atlassian.jira.index.ha.backup.BackupBuilder;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.collect.EnclosedIterable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.jcip.annotations.ThreadSafe;
import org.apache.lucene.document.Document;

@ThreadSafe
public class MockIssueIndexer
implements IssueIndexer {
    public final int indexWorkTime;
    public final int optimizationWorkTime;
    public final Collection<Issue> indexedIssues = new ConcurrentLinkedQueue<Issue>();
    public final Collection<Issue> reIndexedIssues = new ConcurrentLinkedQueue<Issue>();
    public final AtomicInteger optimizations = new AtomicInteger();

    public MockIssueIndexer() {
        this(1000, 2000);
    }

    public MockIssueIndexer(int indexSleepTime, int optimizationSleepTime) {
        this.indexWorkTime = indexSleepTime;
        this.optimizationWorkTime = optimizationSleepTime;
    }

    public Index.Result deIndexProject(Project project, boolean shouldReplicate) {
        return null;
    }

    public Index.Result indexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, @Nonnull IssueIndexingParams issueIndexingParams) {
        return null;
    }

    public Index.Result deindexIssues(@Nonnull Collection<? extends WithId> issues, @Nonnull Context context) {
        return null;
    }

    public Index.Result deindexIssues(@Nonnull Collection<? extends WithId> issues, @Nonnull Context context, boolean shouldReplicate) {
        return null;
    }

    public AccumulatingResultBuilder reindexIssuesBatchMode(@Nonnull IssuesBatcher issuesBatcher, @Nonnull Context context, @Nonnull IssueIndexingParams issueIndexingParams) {
        return null;
    }

    public Index.Result reindexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, IssueIndexingParams issueIndexingParams, boolean conditionalUpdate, boolean shouldReplicate) {
        this.reIndexedIssues.addAll(EnclosedIterable.Functions.toList(issues));
        return new MockResult(this.indexWorkTime);
    }

    public AccumulatingResultBuilder indexIssuesBatchMode(@Nonnull IssuesBatcher batcher, @Nonnull Context context, @Nonnull IssueIndexingParams issueIndexingParams) {
        return null;
    }

    public Index.Result reindexComments(@Nonnull Collection<Comment> comments, @Nonnull Context context, boolean shouldReplicate) {
        return null;
    }

    public Index.Result reindexCommentsInParallel(@Nonnull Collection<Comment> comments, @Nonnull Context context) {
        return null;
    }

    public Index.Result reindexWorklogsInParallel(@Nonnull Collection<Worklog> worklogs, @Nonnull Context context) {
        return null;
    }

    public Index.Result reindexWorklogs(@Nonnull Collection<Worklog> worklogs, @Nonnull Context context, boolean shouldReplicate) {
        return null;
    }

    public Index.Result deindexComments(@Nonnull Collection<? extends WithId> comments, @Nonnull Context context, boolean shouldReplicate) {
        return null;
    }

    public Index.Result deindexWorklogs(@Nonnull Collection<? extends WithId> worklogs, @Nonnull Context context, boolean shouldReplicate) {
        return null;
    }

    public Index.Result conditionalUpdateWithVersion(IndexDirectoryFactory.Name indexName, Document document) {
        return null;
    }

    public Index.Result conditionalUpdateWithVersion(Document issueDocument, Collection<Document> commentDocuments, Collection<Document> changeHistoryDocuments, Collection<Document> worklogDocuments) {
        return null;
    }

    public Index.Result optimize() {
        this.optimizations.incrementAndGet();
        return new MockResult(this.optimizationWorkTime);
    }

    public void deleteIndexes() {
    }

    public void deleteIndexes(IssueIndexingParams issueIndexingParams) {
    }

    public void shutdown() {
    }

    public UnmanagedIndexSearcher openEntitySearcher(IndexDirectoryFactory.Name index) {
        return null;
    }

    public List<String> getIndexPaths() {
        return null;
    }

    public String getIndexRootPath() {
        return null;
    }

    public void contributeToBackup(BackupBuilder backupBuilder) {
    }

    private static final class MockResult
    implements Index.Result {
        private final int workTime;
        private volatile boolean done = false;

        public MockResult(int sleepTime) {
            this.workTime = sleepTime;
        }

        public void await() {
            this.simulateWork();
        }

        public boolean await(long timeout, TimeUnit unit) {
            if (unit.toMillis(timeout) > (long)this.workTime) {
                this.simulateWork();
                return true;
            }
            try {
                unit.sleep(timeout);
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }

        public boolean isDone() {
            return this.done;
        }

        private void simulateWork() {
            try {
                Thread.sleep(this.workTime);
                this.done = true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

