/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.ofbiz;

import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelReader;

public class ModelReaderMock {
    private ModelReaderMock() {
    }

    public static ModelReader getMock() {
        return ModelReaderMock.getMock(null);
    }

    public static ModelReader getMock(Delegate delegate) {
        ModelReader result = (ModelReader)Mockito.mock(ModelReader.class);
        try {
            Mockito.lenient().when((Object)result.getModelEntity(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
                String entityName = (String)invocation.getArguments()[0];
                Delegate sanitizedDelegate = delegate != null ? delegate : DefaultDelegate.INSTANCE;
                return sanitizedDelegate.getModelEntity(entityName);
            });
        }
        catch (GenericEntityException e) {
            throw new AssertionError((Object)e);
        }
        return result;
    }

    public static interface Delegate {
        public ModelEntity getModelEntity(String var1);
    }

    private static class DefaultDelegate
    implements Delegate {
        public static Delegate INSTANCE = new DefaultDelegate();

        private DefaultDelegate() {
        }

        @Override
        public ModelEntity getModelEntity(String entityName) {
            return new MockModelEntity(entityName);
        }
    }

    private static class MockModelEntity
    extends ModelEntity {
        public MockModelEntity(String entityName) {
            this.setEntityName(entityName);
        }

        public ModelField getField(String fieldName) {
            return new ModelField(fieldName, null, null, false, null);
        }
    }
}

