/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.plugin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import java.util.WeakHashMap;

public class MockUrlFactory {
    private final Map<URI, byte[]> storage = new WeakHashMap<URI, byte[]>();
    private final URLStreamHandler handler = new MockUrlStreamHandler();
    private static MockUrlFactory instance = null;

    public static synchronized MockUrlFactory getInstance() {
        if (instance == null) {
            instance = new MockUrlFactory();
        }
        return instance;
    }

    private MockUrlFactory() {
    }

    public URL build(String path, String value) {
        try {
            return this.build(path, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (UnsupportedCharsetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public URL build(String path, byte[] value) {
        try {
            URL url = new URL("memory", "", -1, path, this.handler);
            this.storage.put(url.toURI(), value);
            return url;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getValue(URL key) {
        try {
            return this.storage.get(key.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private class MockUrlStreamHandler
    extends URLStreamHandler {
        private MockUrlStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(final URL u) throws IOException {
            if (!u.getProtocol().equals("memory")) {
                throw new IOException("Unsupported protocol: " + u.getProtocol());
            }
            return new URLConnection(u){
                private byte[] data;
                {
                    super(url);
                    this.data = null;
                }

                @Override
                public void connect() throws IOException {
                    this.initOnDemand();
                    this.verifyDataAvailability();
                    this.connected = true;
                }

                @Override
                public long getContentLengthLong() {
                    this.initOnDemand();
                    if (this.data == null) {
                        return 0L;
                    }
                    return this.data.length;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    this.initOnDemand();
                    this.verifyDataAvailability();
                    return new ByteArrayInputStream(this.data);
                }

                private void initOnDemand() {
                    if (this.data == null) {
                        try {
                            this.data = MockUrlFactory.this.storage.get(u.toURI());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                }

                private void verifyDataAvailability() throws IOException {
                    if (this.data == null) {
                        throw new IOException("In-memory data cannot be found for the " + u.getPath());
                    }
                }
            };
        }
    }
}

