/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.servlet;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;

public class MockServletContext
implements ServletContext {
    private final String realPath;
    private final Map<String, FilterRegistration.Dynamic> filterRegistrations = new LinkedHashMap<String, FilterRegistration.Dynamic>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public MockServletContext() {
        this(null);
    }

    public MockServletContext(String realPath) {
        this.realPath = realPath;
    }

    public ServletContext getContext(String s) {
        return this;
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getMimeType(String s) {
        return null;
    }

    public Set getResourcePaths(String s) {
        return null;
    }

    public URL getResource(String s) throws MalformedURLException {
        return null;
    }

    public InputStream getResourceAsStream(String s) {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        return null;
    }

    public Servlet getServlet(String s) throws ServletException {
        return null;
    }

    public Enumeration getServlets() {
        return null;
    }

    public Enumeration getServletNames() {
        return null;
    }

    public void log(String s) {
    }

    public void log(Exception e, String s) {
    }

    public void log(String s, Throwable throwable) {
    }

    public String getRealPath(String s) {
        return this.realPath;
    }

    public String getServerInfo() {
        return "JIRA Mock Application Server";
    }

    public String getInitParameter(String s) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return null;
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public Enumeration getAttributeNames() {
        Set<String> set = this.attributes.keySet();
        return new Vector<String>(set).elements();
    }

    public void setAttribute(String s, Object o) {
        this.attributes.put(s, o);
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }

    public String getServletContextName() {
        return "jira";
    }

    public String getContextPath() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getEffectiveMajorVersion() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getEffectiveMinorVersion() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean setInitParameter(String name, String value) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ServletRegistration getServletRegistration(String servletName) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        FilterRegistrationDynamic filterRegistration = new FilterRegistrationDynamic(filter);
        FilterRegistration.Dynamic prev = this.filterRegistrations.putIfAbsent(filterName, filterRegistration);
        if (prev != null) {
            throw new IllegalStateException("Filter already registered: " + filterName);
        }
        return filterRegistration;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        try {
            return this.addFilter(filterName, filterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.filterRegistrations;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addListener(String className) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ClassLoader getClassLoader() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getVirtualServerName() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getSessionTimeout() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setSessionTimeout(int sessionTimeout) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getRequestCharacterEncoding() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setRequestCharacterEncoding(String encoding) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getResponseCharacterEncoding() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setResponseCharacterEncoding(String encoding) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static class FilterRegistrationDynamic
    implements FilterRegistration.Dynamic {
        private final Filter filter;
        private final Set<SingleMapping> mappings = new HashSet<SingleMapping>();
        private final Map<String, String> initParams = new HashMap<String, String>();

        public FilterRegistrationDynamic(Filter filter) {
            this.filter = filter;
        }

        public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Collection<String> getServletNameMappings() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
            for (DispatcherType dispatcherType : dispatcherTypes) {
                for (String urlPattern : urlPatterns) {
                    this.mappings.add(new SingleMapping(dispatcherType, isMatchAfter, urlPattern));
                }
            }
        }

        public Collection<String> getUrlPatternMappings() {
            return this.mappings.stream().map(mapping -> mapping.pattern).collect(Collectors.toList());
        }

        public Collection<SingleMapping> getMappings() {
            return Collections.unmodifiableSet(this.mappings);
        }

        public void setAsyncSupported(boolean isAsyncSupported) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getName() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getClassName() {
            return this.filter.getClass().getName();
        }

        public boolean setInitParameter(String name, String value) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0);
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            return this.initParams.putIfAbsent(name, value) == null;
        }

        public String getInitParameter(String name) {
            return this.initParams.get(name);
        }

        public Set<String> setInitParameters(Map<String, String> initParameters) {
            return initParameters.entrySet().stream().filter(entry -> !this.setInitParameter((String)entry.getKey(), (String)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
        }

        public Map<String, String> getInitParameters() {
            return Collections.unmodifiableMap(this.initParams);
        }

        public static class SingleMapping {
            private final String pattern;
            private final DispatcherType dispatcherType;
            private final boolean isMatchAfter;

            public SingleMapping(DispatcherType dispatcherType, boolean isMatchAfter, String pattern) {
                this.dispatcherType = dispatcherType;
                this.isMatchAfter = isMatchAfter;
                this.pattern = pattern;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SingleMapping that = (SingleMapping)o;
                return this.isMatchAfter == that.isMatchAfter && Objects.equals(this.pattern, that.pattern) && this.dispatcherType == that.dispatcherType;
            }

            public int hashCode() {
                return Objects.hash(this.pattern, this.dispatcherType, this.isMatchAfter);
            }

            public String toString() {
                return "SingleMapping{pattern='" + this.pattern + "', dispatcherType=" + this.dispatcherType + ", isMatchAfter=" + this.isMatchAfter + "}";
            }
        }
    }
}

