/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class MockRoleActor
implements ProjectRoleActor {
    private final String descriptor;
    private final String type;
    private final Long projectId;
    private final Long projectRoleId;
    private final String parameter;

    public MockRoleActor(String descriptor, String parameter) {
        this(null, null, descriptor, parameter, null);
    }

    public MockRoleActor(Long projectRoleId, Long projectId, String descriptor, String parameter, String type) {
        this.projectId = projectId;
        this.projectRoleId = projectRoleId;
        this.descriptor = descriptor;
        this.parameter = parameter;
        this.type = type;
    }

    public MockRoleActor(Long projectRoleId, Long projectId, String parameter, String type) {
        this(projectRoleId, projectId, type + ":" + parameter, parameter, type);
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getPrettyName() {
        return null;
    }

    public String getType() {
        return this.type;
    }

    public Set<ApplicationUser> getUsers() {
        return ImmutableSet.of();
    }

    public boolean contains(ApplicationUser user) {
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Long getProjectRoleId() {
        return this.projectRoleId;
    }

    public Long getId() {
        return null;
    }

    public String getParameter() {
        return this.parameter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockRoleActor that = (MockRoleActor)o;
        if (this.descriptor != null ? !this.descriptor.equals(that.descriptor) : that.descriptor != null) {
            return false;
        }
        if (this.parameter != null ? !this.parameter.equals(that.parameter) : that.parameter != null) {
            return false;
        }
        if (this.projectId != null ? !this.projectId.equals(that.projectId) : that.projectId != null) {
            return false;
        }
        if (this.projectRoleId != null ? !this.projectRoleId.equals(that.projectRoleId) : that.projectRoleId != null) {
            return false;
        }
        return !(this.type == null ? that.type != null : !this.type.equals(that.type));
    }

    public int hashCode() {
        int result = this.descriptor != null ? this.descriptor.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.projectId != null ? this.projectId.hashCode() : 0);
        result = 31 * result + (this.projectRoleId != null ? this.projectRoleId.hashCode() : 0);
        result = 31 * result + (this.parameter != null ? this.parameter.hashCode() : 0);
        return result;
    }
}

