/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.services.LocalService;
import com.opensymphony.module.propertyset.PropertySet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MockJiraServiceContainer
implements JiraServiceContainer {
    private final Integer id;
    private final boolean usable;
    private final boolean running;
    private final boolean due;
    private final String serviceClass;
    private final String name;

    private MockJiraServiceContainer(Integer id, boolean usable, boolean running, boolean due, String serviceClass, String name) {
        this.id = id;
        this.usable = usable;
        this.running = running;
        this.due = due;
        this.serviceClass = serviceClass;
        this.name = name;
    }

    public long getDelay() {
        return 100000L;
    }

    public String getCronExpression() {
        return "0 0/1 * 1/1 * ? *";
    }

    public void setCronExpression(String cron) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Long getId() {
        return this.id.longValue();
    }

    public long getLastRun() {
        return System.currentTimeMillis() - 500000L;
    }

    public boolean isDueAt(long time) {
        return this.due;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public Class getServiceClassObject() {
        try {
            return Class.forName(this.serviceClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isLocalService() {
        return LocalService.class.isAssignableFrom(this.getServiceClassObject());
    }

    public boolean isUsable() {
        return this.usable;
    }

    public void setDelay(long delay) {
        throw new UnsupportedOperationException();
    }

    public void setLastRun() {
        throw new UnsupportedOperationException();
    }

    public void setRunning(boolean running) {
        throw new UnsupportedOperationException();
    }

    public void destroy() {
        throw new UnsupportedOperationException();
    }

    public String getDescription() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public void init(PropertySet props) throws ObjectConfigurationException {
        throw new UnsupportedOperationException();
    }

    public boolean isInternal() {
        throw new UnsupportedOperationException();
    }

    public boolean isUnique() {
        throw new UnsupportedOperationException();
    }

    public void run() {
        throw new UnsupportedOperationException();
    }

    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    public String getDefaultProperty(String propertyKey) throws ObjectConfigurationException {
        throw new UnsupportedOperationException();
    }

    public String getKey() {
        throw new UnsupportedOperationException();
    }

    public Long getLongProperty(String propertyKey) throws ObjectConfigurationException {
        throw new UnsupportedOperationException();
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return null;
    }

    public PropertySet getProperties() throws ObjectConfigurationException {
        throw new UnsupportedOperationException();
    }

    public String getProperty(String propertyKey) throws ObjectConfigurationException {
        throw new UnsupportedOperationException();
    }

    public String getTextProperty(String propertyKey) throws ObjectConfigurationException {
        throw new UnsupportedOperationException();
    }

    public boolean hasProperty(String propertyKey) throws ObjectConfigurationException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MockJiraServiceContainer)) {
            return false;
        }
        MockJiraServiceContainer rhs = (MockJiraServiceContainer)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)rhs.id).append((Object)this.serviceClass, (Object)rhs.serviceClass).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("usable", this.usable).append("running", this.running).append("due", this.due).append("serviceClass", (Object)this.serviceClass).append("name", (Object)this.name).toString();
    }

    public static class Builder {
        private int id;
        private boolean usable;
        private boolean running = false;
        private boolean due = false;
        private String serviceClass = "";
        private String name = "";

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder usable(boolean usable) {
            this.usable = usable;
            return this;
        }

        public Builder running(boolean running) {
            this.running = running;
            return this;
        }

        public Builder due(boolean due) {
            this.due = due;
            return this;
        }

        public Builder serviceClass(String serviceClass) {
            this.serviceClass = serviceClass;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public MockJiraServiceContainer build() {
            return new MockJiraServiceContainer(this.id, this.usable, this.running, this.due, this.serviceClass, this.name);
        }
    }
}

