/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskProgressIndicator;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Nullable;

public class MockTaskDescriptor<V extends Serializable>
implements TaskDescriptor<V> {
    private V result;
    private Date submittedTime;
    private Date startedTime;
    private Date finishedTime;
    private TaskProgressIndicator taskProgressIndicator;
    private String description;
    private Long taskId;
    private long elapsedRunTime;
    private TaskContext taskContext;
    private String userName;
    private boolean cancelled;
    private boolean cancelable;
    private boolean selfRecovering;
    private String nodeId;
    private SpanningOperation spanningOperation;

    public MockTaskDescriptor() {
        this.clear();
    }

    public void clear() {
        this.elapsedRunTime = 0L;
        this.taskId = null;
        this.result = null;
        this.submittedTime = null;
        this.startedTime = null;
        this.finishedTime = null;
        this.taskProgressIndicator = null;
        this.description = null;
        this.taskContext = null;
        this.userName = null;
        this.cancelable = false;
        this.cancelled = false;
        this.selfRecovering = false;
        this.nodeId = null;
        this.spanningOperation = null;
    }

    public V getResult() {
        return this.result;
    }

    public boolean isStarted() {
        return this.startedTime != null;
    }

    public boolean isFinished() {
        return this.finishedTime != null;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public Date getStartedTimestamp() {
        return this.startedTime;
    }

    public Date getFinishedTimestamp() {
        return this.finishedTime;
    }

    public Date getSubmittedTimestamp() {
        return this.submittedTime;
    }

    public long getElapsedRunTime() {
        return this.elapsedRunTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getDescription() {
        return this.description;
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public String getProgressURL() {
        return "/userUrl?user=";
    }

    public TaskProgressIndicator getTaskProgressIndicator() {
        return this.taskProgressIndicator;
    }

    public void setResult(V result) {
        this.result = result;
    }

    public void setSubmittedTime(Date submittedTime) {
        this.submittedTime = submittedTime;
    }

    public void setStartedTime(Date startedTime) {
        this.startedTime = startedTime;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public void setTaskProgressIndicator(TaskProgressIndicator taskProgressIndicator) {
        this.taskProgressIndicator = taskProgressIndicator;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setElapsedRunTime(long elapsedRunTime) {
        this.elapsedRunTime = elapsedRunTime;
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean isSelfRecovering() {
        return this.selfRecovering;
    }

    public void setSelfRecovering(boolean selfRecovering) {
        this.selfRecovering = selfRecovering;
    }

    public boolean isCancellable() {
        return this.cancelable;
    }

    public void setCancelable(boolean isCancelable) {
        this.cancelable = isCancelable;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Nullable
    public SpanningOperation getSpanningOperation() {
        return this.spanningOperation;
    }

    public void setSpanningOperation(SpanningOperation spanningOperation) {
        this.spanningOperation = spanningOperation;
    }
}

