/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.test;

import com.atlassian.jira.web.ServletContextProviderListener;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.mockito.Mockito;

public class ServletContextProviderExtension
implements BeforeAllCallback,
AfterAllCallback {
    private final ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
    private final ServletContextEvent servletContextEvent;
    private final ServletContextProviderListener servletContextProviderListener = new ServletContextProviderListener();

    @Nonnull
    public static ServletContextProviderExtension setUpServletContextProvider() {
        return new ServletContextProviderExtension();
    }

    ServletContextProviderExtension() {
        this.servletContextEvent = new ServletContextEvent(this.servletContext);
    }

    @Nonnull
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.fireContextDestroyed();
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        this.fireContextInitialized();
    }

    private void fireContextInitialized() {
        this.servletContextProviderListener.contextInitialized(this.servletContextEvent);
    }

    private void fireContextDestroyed() {
        this.servletContextProviderListener.contextDestroyed(this.servletContextEvent);
    }
}

