/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityLink;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import java.net.URI;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class AffectedEntityMatcher {
    public static Matcher<AffectedEntity> type(final AffectedEntityType expected) {
        return new TypeSafeMatcher<AffectedEntity>(){

            protected boolean matchesSafely(AffectedEntity item) {
                return item.getType() == expected;
            }

            protected void describeMismatchSafely(AffectedEntity item, Description description) {
                description.appendText("was ").appendText(item.getType().name());
            }

            public void describeTo(Description description) {
                description.appendText("AffectedEntity of type " + expected);
            }
        };
    }

    public static Matcher<AffectedEntity> numberOfOccurrences(final long expected) {
        return new TypeSafeMatcher<AffectedEntity>(){

            protected boolean matchesSafely(AffectedEntity item) {
                return item.getNumberOfOccurrences().map(actual -> actual == expected).orElse(false);
            }

            protected void describeMismatchSafely(AffectedEntity item, Description description) {
                description.appendText("was ").appendText(item.getNumberOfOccurrences().map(String::valueOf).orElse("none"));
            }

            public void describeTo(Description description) {
                description.appendText("AffectedEntity with occurrence number " + expected);
            }
        };
    }

    public static Matcher<AffectedEntity> url(final String expected) {
        return new TypeSafeMatcher<AffectedEntity>(){

            protected boolean matchesSafely(AffectedEntity item) {
                return item.getLink().map(link -> link.getUri().toString().equals(expected)).orElse(false);
            }

            protected void describeMismatchSafely(AffectedEntity item, Description description) {
                description.appendText("was ").appendText(item.getLink().map(AffectedEntityLink::getUri).map(URI::toString).orElse("none"));
            }

            public void describeTo(Description description) {
                description.appendText("AffectedEntity with URL " + expected);
            }
        };
    }
}

