/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.DelegatingApplicationUser;
import com.atlassian.jira.user.MockApplicationUser;
import com.atlassian.jira.user.MockCrowdService;
import com.atlassian.jira.user.MockUserKeyService;
import com.atlassian.jira.user.UserDetails;
import com.atlassian.jira.user.util.DuplicatedUsersToDirectoriesMapping;
import com.atlassian.jira.user.util.UserIdentity;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MockUserManager
implements UserManager {
    final MockUserKeyService mockUserKeyService;
    private final Map<Long, Directory> directories = Maps.newHashMap((Map)ImmutableMap.of((Object)1L, (Object)new MockDirectory()));
    final Map<String, ApplicationUser> userMap = new HashMap<String, ApplicationUser>();
    private boolean writableDirectory = true;
    private boolean groupWritableDirectory = true;
    private MockCrowdService crowdService;
    private boolean alwaysReturnUsers = false;
    private boolean useCrowdServiceToGetUsers = false;

    public MockUserManager() {
        this(new MockUserKeyService());
    }

    public MockUserManager(MockUserKeyService mockUserKeyService) {
        this.mockUserKeyService = mockUserKeyService;
    }

    public MockUserManager(MockCrowdService crowdService) {
        this();
        this.crowdService = crowdService;
    }

    public MockUserManager alwaysReturnUsers() {
        this.alwaysReturnUsers = true;
        return this;
    }

    public MockUserManager useCrowdServiceToGetUsers() {
        this.useCrowdServiceToGetUsers = true;
        return this;
    }

    public MockUserManager doNotUseCrowdServiceToGetUsers() {
        this.useCrowdServiceToGetUsers = false;
        return this;
    }

    public Optional<ApplicationUser> getUserById(Long id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setCrowdService(MockCrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public int getTotalUserCount() {
        return this.userMap.size();
    }

    public ApplicationUser getUserByKey(@Nullable String userKey) {
        String username = this.mockUserKeyService.getUsernameForKey(userKey);
        ApplicationUser user = this.userMap.get(username);
        if (user == null) {
            return null;
        }
        return user;
    }

    public ApplicationUser getUserByName(@Nullable String userName) {
        if (userName == null) {
            return null;
        }
        String lowerUserName = IdentifierUtils.toLowerCase((String)userName);
        ApplicationUser user = this.userMap.get(lowerUserName);
        if (user == null) {
            return null;
        }
        return user;
    }

    public ApplicationUser getUserByKeyEvenWhenUnknown(@Nullable String userKey) {
        if (userKey == null) {
            return null;
        }
        ApplicationUser user = this.getUserByKey(userKey);
        if (user != null) {
            return user;
        }
        return new DelegatingApplicationUser(Long.valueOf(MockApplicationUser.SEQUENCE.getAndIncrement()), userKey, (User)new ImmutableUser(-1L, userKey, userKey, "?", false));
    }

    public ApplicationUser getUserByNameEvenWhenUnknown(@Nullable String userName) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ApplicationUser findUserInDirectory(String userName, Long directoryId) {
        if (directoryId == 1L) {
            return this.userMap.get(IdentifierUtils.toLowerCase((String)userName));
        }
        return null;
    }

    public boolean canUpdateUser(ApplicationUser user) {
        return user != null && this.writableDirectory;
    }

    public boolean userCanUpdateOwnDetails(@Nonnull ApplicationUser user) {
        return this.canUpdateUser(user);
    }

    public boolean canRenameUser(ApplicationUser user) {
        return this.canUpdateUser(user);
    }

    public void updateUser(ApplicationUser user) {
        this.userMap.put(user.getKey(), user);
    }

    public boolean canUpdateUserPassword(ApplicationUser user) {
        return true;
    }

    public boolean canUpdateGroupMembershipForUser(ApplicationUser user) {
        return true;
    }

    public Group getGroup(@Nullable String groupName) {
        return null;
    }

    public Group getGroupObject(@Nullable String groupName) {
        return null;
    }

    @Nonnull
    public List<Directory> getWritableDirectories() {
        if (this.writableDirectory) {
            return Collections.singletonList(this.directories.get(1L));
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Optional<Directory> getDefaultCreateDirectory() {
        if (this.writableDirectory) {
            return Optional.of(this.directories.get(1L));
        }
        return Optional.empty();
    }

    public boolean hasWritableDirectory() {
        return this.writableDirectory;
    }

    public void setWritableDirectory(boolean writableDirectory) {
        this.writableDirectory = writableDirectory;
    }

    public boolean hasPasswordWritableDirectory() {
        return true;
    }

    public boolean hasGroupWritableDirectory() {
        return this.groupWritableDirectory;
    }

    public void setGroupWritableDirectory(boolean groupWritableDirectory) {
        this.groupWritableDirectory = groupWritableDirectory;
    }

    public boolean canDirectoryUpdateUserPassword(Directory directory) {
        return true;
    }

    public Directory getDirectory(Long directoryId) {
        return this.directories.getOrDefault(directoryId, null);
    }

    public boolean isUserExisting(@Nullable ApplicationUser user) {
        return user != null && user.getDirectoryId() != -1L;
    }

    public boolean isUserDeleted(@Nullable ApplicationUser user) {
        return user != null && user.getDirectoryId() == -1L && user.getId() != -1L;
    }

    @Nonnull
    public String generateRandomPassword() {
        return "secret01";
    }

    @Nonnull
    public Collection<ApplicationUser> getAllApplicationUsers() {
        if (this.useCrowdServiceToGetUsers) {
            return ImmutableSet.copyOf((Collection)ApplicationUsers.from(this.crowdService.getAllUsers()));
        }
        return Sets.newHashSet(this.userMap.values());
    }

    public ApplicationUser addUser(ApplicationUser user) {
        String username = IdentifierUtils.toLowerCase((String)user.getUsername());
        this.userMap.put(username, user);
        this.mockUserKeyService.setMapping(user.getKey(), username);
        return user;
    }

    public MockUserKeyService getMockUserKeyService() {
        return this.mockUserKeyService;
    }

    @Nonnull
    public UserManager.UserState getUserState(@Nullable ApplicationUser user) {
        if (user == null) {
            return UserManager.UserState.INVALID_USER;
        }
        return this.getUserState(user.getUsername(), user.getDirectoryId());
    }

    @Nonnull
    public DuplicatedUsersToDirectoriesMapping getDuplicatedUserMapping() {
        return DuplicatedUsersToDirectoriesMapping.EMPTY;
    }

    @Nonnull
    public ApplicationUser createUser(@Nonnull UserDetails userData) throws CreateException, PermissionException {
        MockApplicationUser user = new MockApplicationUser(userData.getUsername(), userData.getDisplayName(), userData.getEmailAddress());
        this.addUser(user);
        if (!userData.getDirectoryId().isPresent() && this.crowdService != null) {
            String password = Strings.isNullOrEmpty((String)userData.getPassword()) ? "foo" : userData.getPassword();
            this.crowdService.addUser(user.getDirectoryUser(), password);
        }
        return user;
    }

    public Optional<UserIdentity> getUserIdentityById(Long id) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Optional<UserIdentity> getUserIdentityByKey(String key) {
        return this.getUserIdentityByUsername((String)MoreObjects.firstNonNull((Object)this.mockUserKeyService.getUsernameForKey(key), (Object)key));
    }

    public Optional<UserIdentity> getUserIdentityByUsername(String username) {
        if (this.alwaysReturnUsers) {
            return Optional.of(UserIdentity.withId((Long)MockApplicationUser.SEQUENCE.getAndIncrement()).key(username).andUsername(username));
        }
        ApplicationUser appUser = this.userMap.get(username);
        return appUser != null ? Optional.of(UserIdentity.withId((Long)appUser.getId()).key(appUser.getKey()).andUsername(appUser.getUsername())) : Optional.empty();
    }

    @Nonnull
    public UserManager.UserState getUserState(@Nonnull String username, long directoryId) {
        if (this.findUserInDirectory(username, directoryId) != null) {
            return UserManager.UserState.NORMAL_USER;
        }
        return UserManager.UserState.INVALID_USER;
    }

    public void putDirectory(Long directoryId, Directory directory) {
        this.directories.put(directoryId, directory);
    }

    class MockDirectory
    implements Directory {
        private final Date CREATED = new Date();

        MockDirectory() {
        }

        public Long getId() {
            return 1L;
        }

        public String getName() {
            return "Mock Internal Directory";
        }

        public boolean isActive() {
            return true;
        }

        public String getEncryptionType() {
            return "plaintext";
        }

        public Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }

        public Set<OperationType> getAllowedOperations() {
            if (MockUserManager.this.writableDirectory) {
                return EnumSet.allOf(OperationType.class);
            }
            return EnumSet.noneOf(OperationType.class);
        }

        public String getDescription() {
            return "Mock internal directory for unit tests";
        }

        public DirectoryType getType() {
            return DirectoryType.INTERNAL;
        }

        public String getImplementationClass() {
            return InternalDirectory.class.getName();
        }

        public Date getCreatedDate() {
            return this.CREATED;
        }

        public Date getUpdatedDate() {
            return this.CREATED;
        }

        public Set<String> getValues(String s) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public String getValue(String s) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public Set<String> getKeys() {
            return MockUserManager.this.userMap.keySet();
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

