/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.RecoveryMode;
import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.fugue.Option;

public class StaticRecoveryMode
implements RecoveryMode {
    private final String recoveryUsername;

    public StaticRecoveryMode(String recoveryUsername) {
        this.recoveryUsername = recoveryUsername;
    }

    public boolean isRecoveryModeOn() {
        return this.recoveryUsername != null;
    }

    public boolean isRecoveryUser(ApplicationUser user) {
        return this.isRecoveryUsername(user == null ? null : user.getName());
    }

    public boolean isRecoveryUsername(String username) {
        return this.recoveryUsername != null && this.recoveryUsername.equals(username);
    }

    public Option<String> getRecoveryUsername() {
        return Option.option((Object)this.recoveryUsername);
    }

    public static StaticRecoveryMode enabled(String user) {
        return new StaticRecoveryMode((String)Assertions.notNull((String)"user", (Object)user));
    }

    public static StaticRecoveryMode disabled() {
        return new StaticRecoveryMode(null);
    }
}

