/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.ErrorCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class ErrorCollectionAssert {
    private static final List<String> NO_ERROR_MESSAGES = ImmutableList.of();
    private static final Map<String, String> NO_FIELD_ERRORS = ImmutableMap.of();

    public static void assert1ErrorMessage(ErrorCollection errorCollection, String expectedErrorMessage) {
        Assert.assertThat((String)"Expected to find exactly one global error message", (Object)errorCollection.getErrorMessages(), (Matcher)Matchers.contains((Object[])new String[]{expectedErrorMessage}));
        Assert.assertEquals((String)"Expected only a single global error, but also found a field-specific error.", NO_FIELD_ERRORS, (Object)errorCollection.getErrors());
    }

    public static void assert1FieldError(ErrorCollection errorCollection, String fieldName, String expectedErrorMessage) {
        Assert.assertEquals((String)"Expected only a field error, but also found a global error", NO_ERROR_MESSAGES, (Object)errorCollection.getErrorMessages());
        ErrorCollectionAssert.assertFieldError(errorCollection, fieldName, expectedErrorMessage);
    }

    public static void assertFieldError(ErrorCollection errorCollection, String fieldName, String expectedErrorMessage) {
        Assert.assertThat((String)("Error for field " + fieldName), (Object)((String)errorCollection.getErrors().get(fieldName)), (Matcher)Matchers.is((Object)expectedErrorMessage));
        Assert.assertTrue((String)"hasAnyErrors()", (boolean)errorCollection.hasAnyErrors());
    }

    public static void assertNoErrors(ErrorCollection errorCollection) {
        Assert.assertEquals((String)"getErrorMessages()", NO_ERROR_MESSAGES, (Object)errorCollection.getErrorMessages());
        Assert.assertEquals((String)"getErrors()", NO_FIELD_ERRORS, (Object)errorCollection.getErrors());
        Assert.assertFalse((String)"hasAnyErrors()", (boolean)errorCollection.hasAnyErrors());
    }
}

