/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.BaseUrl;
import com.google.common.base.Function;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MockBaseUrl
implements BaseUrl {
    private String currentBaseUrl;
    private final String staticBaseUrl;

    public MockBaseUrl(String baseUrl, String staticBaseUrl) {
        this.staticBaseUrl = staticBaseUrl;
        this.currentBaseUrl = baseUrl;
    }

    @Nonnull
    public String getBaseUrl() {
        return this.currentBaseUrl;
    }

    @Nonnull
    public String getCanonicalBaseUrl() {
        return this.currentBaseUrl;
    }

    public URI getBaseUri() {
        return URI.create(this.currentBaseUrl);
    }

    @Nonnull
    public URI resolveAddress(@Nonnull String relative) {
        return URI.create(this.getBaseUrl() + "/" + relative).normalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <I, O> O runWithStaticBaseUrl(@Nullable I input, @Nonnull Function<I, O> runnable) {
        String lastUrl = this.currentBaseUrl;
        this.currentBaseUrl = this.staticBaseUrl;
        try {
            Object object = runnable.apply(input);
            return (O)object;
        }
        finally {
            this.currentBaseUrl = lastUrl;
        }
    }
}

