/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.AssignableWorkflowSchemeStore;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.ofbiz.core.entity.GenericValue;

class MockAssignableWorkflowSchemeState
implements AssignableWorkflowSchemeStore.AssignableState {
    private Long id;
    private Map<String, String> mappings;
    private String name;
    private String description;

    MockAssignableWorkflowSchemeState(AssignableWorkflowSchemeStore.AssignableState scheme) {
        this.id = scheme.getId();
        this.mappings = Maps.newHashMap((Map)scheme.getMappings());
        this.name = scheme.getName();
        this.description = scheme.getDescription();
    }

    MockAssignableWorkflowSchemeState(AssignableWorkflowScheme scheme) {
        this.id = scheme.getId();
        this.mappings = Maps.newHashMap((Map)scheme.getMappings());
        this.name = scheme.getName();
        this.description = scheme.getDescription();
    }

    MockAssignableWorkflowSchemeState(GenericValue scheme, Iterable<GenericValue> entities) {
        this();
        this.setId(scheme.getLong("id"));
        this.setDescription(scheme.getString("description"));
        this.setName(scheme.getString("name"));
        for (GenericValue mapping : entities) {
            String issueType = mapping.getString("issuetype");
            String workflow = mapping.getString("workflow");
            this.setMapping(issueType.equals("0") ? null : issueType, workflow);
        }
    }

    MockAssignableWorkflowSchemeState() {
        this.mappings = Maps.newHashMap();
    }

    MockAssignableWorkflowSchemeState(Long id, String name, String description, Map<String, String> mappings) {
        this.id = id;
        this.mappings = Maps.newHashMap(mappings);
        this.name = name;
        this.description = description;
    }

    MockAssignableWorkflowSchemeState setId(Long id) {
        this.id = id;
        return this;
    }

    MockAssignableWorkflowSchemeState setMappings(Map<String, String> issueTypeToWorkflow) {
        this.mappings = Maps.newHashMap(issueTypeToWorkflow);
        return this;
    }

    MockAssignableWorkflowSchemeState setDefaultWorkflow(String workflow) {
        return this.setMapping(null, workflow);
    }

    MockAssignableWorkflowSchemeState setMapping(String issueType, String workflow) {
        this.mappings.put(issueType, workflow);
        return this;
    }

    MockAssignableWorkflowSchemeState setName(String name) {
        this.name = name;
        return this;
    }

    MockAssignableWorkflowSchemeState setDescription(String description) {
        this.description = description;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public String getDefaultWorkflow() {
        return this.mappings.get(null);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Builder builder() {
        return new Builder(this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockAssignableWorkflowSchemeState that = (MockAssignableWorkflowSchemeState)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.mappings != null ? !this.mappings.equals(that.mappings) : that.mappings != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.mappings != null ? this.mappings.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    static Set<MockAssignableWorkflowSchemeState> readSchemes(OfBizDelegator delegator) {
        HashSet result = Sets.newHashSet();
        List all = delegator.findAll("WorkflowScheme");
        for (GenericValue schemeGv : all) {
            Long schemeId = schemeGv.getLong("id");
            List related = delegator.findByAnd("WorkflowSchemeEntity", (Map)ImmutableMap.of((Object)"scheme", (Object)schemeId));
            result.add(new MockAssignableWorkflowSchemeState(schemeGv, related));
        }
        return result;
    }

    static Set<MockAssignableWorkflowSchemeState> convert(Iterable<AssignableWorkflowSchemeStore.AssignableState> states) {
        HashSet mockStates = Sets.newHashSet();
        for (AssignableWorkflowSchemeStore.AssignableState state : states) {
            mockStates.add(new MockAssignableWorkflowSchemeState(state));
        }
        return mockStates;
    }

    GenericValue saveSchemeOnlyTo(OfBizDelegator delegator) {
        return delegator.createValue("WorkflowScheme", (Map)this.createSchemeFieldMap());
    }

    MockAssignableWorkflowSchemeState saveTo(OfBizDelegator delegator) {
        GenericValue genericValue = this.saveSchemeOnlyTo(delegator);
        for (Map.Entry<String, String> mapping : this.mappings.entrySet()) {
            String issueType = mapping.getKey();
            String workflow = mapping.getValue();
            FieldMap fieldMap = FieldMap.build((String)"scheme", (Object)this.id).add("issuetype", (Object)(issueType == null ? "0" : issueType)).add("workflow", (Object)workflow);
            delegator.createValue("WorkflowSchemeEntity", (Map)fieldMap);
        }
        return this;
    }

    FieldMap createSchemeFieldMap() {
        return FieldMap.build((String)"id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description);
    }

    static class SchemeTable {
        static final String ENTITY = "WorkflowScheme";
        static final String ENTITY_RELATIONSHIP = "ChildWorkflowSchemeEntity";

        SchemeTable() {
        }

        static class Columns {
            static final String ID = "id";
            static final String NAME = "name";
            static final String DESCRIPTION = "description";

            Columns() {
            }
        }
    }

    static class EntityTable {
        static final String ENTITY = "WorkflowSchemeEntity";

        EntityTable() {
        }

        static class Columns {
            static final String WORKFLOW_SCHEME = "scheme";
            static final String WORKFLOW_NAME = "workflow";
            static final String ISSUE_TYPE = "issuetype";

            Columns() {
            }
        }
    }

    static class Builder
    implements AssignableWorkflowSchemeStore.AssignableState.Builder {
        private Long id;
        private Map<String, String> schemeMap;
        private String description;
        private String name;

        public Builder() {
            this.schemeMap = Maps.newHashMap();
        }

        public Builder(AssignableWorkflowSchemeStore.AssignableState state) {
            this.id = state.getId();
            this.schemeMap = Maps.newHashMap((Map)state.getMappings());
            this.name = state.getName();
            this.description = state.getDescription();
        }

        public String getDefaultWorkflow() {
            return this.schemeMap.get(null);
        }

        public Long getId() {
            return this.id;
        }

        public String getDefault() {
            return this.schemeMap.get(null);
        }

        Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public Map<String, String> getMappings() {
            return this.schemeMap;
        }

        public Builder setMappings(Map<String, String> mappings) {
            this.schemeMap = Maps.newHashMap(mappings);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public AssignableWorkflowSchemeStore.AssignableState.Builder setName(String name) {
            this.name = name;
            return this;
        }

        public AssignableWorkflowSchemeStore.AssignableState.Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public MockAssignableWorkflowSchemeState build() {
            return new MockAssignableWorkflowSchemeState(this.id, this.name, this.description, this.schemeMap);
        }
    }
}

