/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.workflow.WorkflowScheme;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class MockWorkflowScheme
implements WorkflowScheme {
    private Long id;
    private Map<String, String> workflowMap;

    public MockWorkflowScheme() {
        this((Long)null);
        this.workflowMap = Maps.newHashMap();
    }

    public MockWorkflowScheme(Long id) {
        this.id = id;
        this.workflowMap = Maps.newHashMap();
    }

    public MockWorkflowScheme(WorkflowScheme workflowScheme) {
        this.id = workflowScheme.getId();
        this.workflowMap = Maps.newHashMap((Map)workflowScheme.getMappings());
    }

    public Long getId() {
        return this.id;
    }

    @Nonnull
    public String getActualWorkflow(String issueTypeId) {
        String workflow = this.workflowMap.get(issueTypeId);
        if (workflow == null) {
            workflow = this.getActualDefaultWorkflow();
        }
        return workflow;
    }

    @Nonnull
    public String getActualDefaultWorkflow() {
        String defaultWorkflow = this.workflowMap.get(null);
        if (defaultWorkflow == null) {
            defaultWorkflow = "jira";
        }
        return defaultWorkflow;
    }

    @Nonnull
    public Map<String, String> getMappings() {
        return this.workflowMap;
    }

    public String getConfiguredDefaultWorkflow() {
        return this.workflowMap.get(null);
    }

    public String getConfiguredWorkflow(String issueTypeId) {
        return this.workflowMap.get(issueTypeId);
    }

    public MockWorkflowScheme setId(Long id) {
        this.id = id;
        return this;
    }

    public MockWorkflowScheme setMappings(Map<String, String> workflowMap) {
        this.workflowMap = Maps.newHashMap(workflowMap);
        return this;
    }

    public MockWorkflowScheme setMapping(String issueType, String workflow) {
        this.workflowMap.put(issueType, workflow);
        return this;
    }

    public MockWorkflowScheme setDefaultWorkflow(String workflow) {
        this.workflowMap.put(null, workflow);
        return this;
    }

    public MockWorkflowScheme clearMappings() {
        this.workflowMap.clear();
        return this;
    }

    public MockWorkflowScheme removeMapping(String issueTypeId) {
        this.workflowMap.remove(issueTypeId);
        return this;
    }

    public MockWorkflowScheme removeDefault() {
        this.workflowMap.remove(null);
        return this;
    }

    public MockWorkflowScheme removeWorkflow(String workflowName) {
        Iterator<String> iterator = this.workflowMap.values().iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (!workflowName.equals(s)) continue;
            iterator.remove();
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockWorkflowScheme that = (MockWorkflowScheme)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.workflowMap != null ? !this.workflowMap.equals(that.workflowMap) : that.workflowMap != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.workflowMap != null ? this.workflowMap.hashCode() : 0);
        return result;
    }
}

